/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.debug.debuggers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.AABB;
import net.refractionapi.refraction.debug.RDebugRenderer;
import net.refractionapi.refraction.helper.data.DoubleMap;
import org.apache.logging.log4j.util.TriConsumer;

public class AABBRenderer
extends RDebugRenderer {
    private final DoubleMap<AABB, Color, Pair<Long, Integer>> boxes = new DoubleMap();

    public AABBRenderer() {
        super("aabb");
    }

    @Override
    protected void render(PoseStack poseStack, MultiBufferSource multiBufferSource) {
        this.boxes.removeIf((color, time) -> (Long)time.getFirst() + (long)((Integer)time.getSecond()).intValue() * 1000L < Util.m_137550_());
        this.boxes.forEach((TriConsumer<AABB, Color, Pair<Long, Integer>>)((TriConsumer)(box, color, time) -> this.renderLineBox(this.applyTransformation((AABB)box), (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f, poseStack, multiBufferSource)));
    }

    @Override
    protected void tick(boolean post) {
    }

    @Override
    protected void fromPacket(FriendlyByteBuf buf) {
        BlockPos corner1 = buf.m_130135_();
        BlockPos corner2 = buf.m_130135_();
        int red = buf.readInt();
        int green = buf.readInt();
        int blue = buf.readInt();
        int time = buf.readInt();
        AABB box = new AABB(corner1.m_252807_(), corner2.m_252807_());
        this.boxes.put(box, new Color(red, green, blue), (Pair<Long, Integer>)Pair.of((Object)Util.m_137550_(), (Object)time));
    }
}

