/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.debug.debuggers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.refractionapi.refraction.debug.RDebugRenderer;

public class PathfindingRenderer
extends RDebugRenderer {
    private final Map<Integer, Path> pathMap = Maps.newHashMap();
    private final Map<Integer, Float> pathMaxDist = Maps.newHashMap();
    private final Map<Integer, Long> creationMap = Maps.newHashMap();

    public PathfindingRenderer() {
        super("pathfinding");
    }

    public void renderPath(PoseStack poseStack, MultiBufferSource buffer, Path path, float p_270841_, boolean p_270481_, boolean p_270748_, double x, double y, double z) {
    }

    public void renderPathLine(PoseStack poseStack, VertexConsumer consumer, Path path, double x, double y, double z) {
        for (int i = 0; i < path.m_77398_(); ++i) {
            Node node = path.m_77375_(i);
            if (this.distanceToCamera(node.m_77288_()) > 80.0f) continue;
            float f = (float)i / (float)path.m_77398_() * 0.33f;
            int j = i == 0 ? 0 : Mth.m_14169_((float)f, (float)0.9f, (float)0.9f);
            int k = j >> 16 & 0xFF;
            int l = j >> 8 & 0xFF;
            int n = j & 0xFF;
        }
    }

    @Override
    protected void render(PoseStack poseStack, MultiBufferSource multiBufferSource) {
        if (!this.pathMap.isEmpty()) {
            long i = Util.m_137550_();
            Vec3 cam = this.cameraPosition();
            for (Integer integer : this.pathMap.keySet()) {
                Path path = this.pathMap.get(integer);
                float f = this.pathMaxDist.get(integer).floatValue();
                this.renderPath(poseStack, multiBufferSource, path, f, true, true, cam.f_82479_, cam.f_82480_, cam.f_82481_);
            }
            for (Integer integer1 : this.creationMap.keySet().toArray(new Integer[0])) {
                if (i - this.creationMap.get(integer1) <= 5000L) continue;
                this.pathMap.remove(integer1);
                this.creationMap.remove(integer1);
            }
        }
    }

    @Override
    protected void tick(boolean post) {
    }

    @Override
    protected void fromPacket(FriendlyByteBuf buf) {
        int id = buf.readInt();
        float maxDistance = buf.readFloat();
        Path path = Path.m_77390_((FriendlyByteBuf)buf);
        this.addPath(id, path, maxDistance);
    }

    public void addPath(int entityId, Path path, float maxDistanceToWaypoint) {
        this.pathMap.put(entityId, path);
        this.creationMap.put(entityId, Util.m_137550_());
        this.pathMaxDist.put(entityId, Float.valueOf(maxDistanceToWaypoint));
    }
}

