/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.debug.debuggers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.refractionapi.refraction.debug.RDebugRenderer;
import net.refractionapi.refraction.helper.math.ColorInterpolator;
import net.refractionapi.refraction.helper.vec3.RAAB;
import net.refractionapi.refraction.helper.vec3.Vec3Helper;

public class RAABBRenderer
extends RDebugRenderer {
    public RAABBRenderer() {
        super("raab");
    }

    @Override
    protected void render(PoseStack poseStack, MultiBufferSource multiBufferSource) {
        RAAB raab = RAAB.create(new Vec3(0.0, 0.0, 0.0), new Vec3(5.0, 4.0, 5.0));
        poseStack.m_85836_();
        Vec3 camera = this.cameraPosition();
        poseStack.m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
        this.renderLineBox(raab, 0.0f, 0.0f, 1.0f, 1.0f, poseStack, multiBufferSource);
        Vec3 start = this.minecraft.f_91074_.m_20182_();
        AABB box = this.minecraft.f_91074_.m_20191_();
        if (raab.m_82381_(box)) {
            raab.forCorners((i, end) -> {
                this.renderLine(start, (Vec3)end, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, poseStack, multiBufferSource);
                float[] angles = Vec3Helper.getDegreesBetweenPoints(start, end);
                this.renderText("%.1f | [%.1f ; %.1f]".formatted(start.m_82554_(end), Float.valueOf(angles[0]), Float.valueOf(angles[1])), start.m_82549_(end), poseStack, multiBufferSource);
            });
        }
        int colorStart = new Color(138, 27, 41).getRGB();
        int colorMid = new Color(96, 37, 54).getRGB();
        int colorEnd = new Color(53, 5, 21).getRGB();
        ColorInterpolator color = new ColorInterpolator().addPoint(10688011, 14360079, 1.0f, 0.3f).addPoint(3540997, 1.0f, 0.8f);
        Color color1 = new Color(color.getColor((float)(Minecraft.m_91087_().f_91074_.f_19797_ % 100) / 100.0f));
        poseStack.m_85849_();
        this.renderBox(Minecraft.m_91087_().f_91074_.m_20191_().m_82386_(3.0, 0.0, 0.0), (float)color1.getRed() / 255.0f, (float)color1.getGreen() / 255.0f, (float)color1.getBlue() / 255.0f, 1.0f, poseStack, multiBufferSource);
    }

    @Override
    protected void tick(boolean post) {
    }

    @Override
    protected void fromPacket(FriendlyByteBuf buf) {
    }
}

