/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.debug.debuggers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import imgui.ImGui;
import imgui.type.ImString;
import java.awt.Color;
import java.util.Arrays;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.refractionapi.refraction.client.ClientData;
import net.refractionapi.refraction.debug.RDebugRenderer;

public class TraceEntitiesRenderer
extends RDebugRenderer {
    float maxDistance = 100.0f;
    CopyOnWriteArraySet<String> match = new CopyOnWriteArraySet();

    public TraceEntitiesRenderer() {
        super("trace_entities");
    }

    @Override
    protected void render(PoseStack poseStack, MultiBufferSource multiBufferSource) {
        ClientLevel level = this.minecraft.f_91073_;
        if (level == null) {
            return;
        }
        level.m_45933_((Entity)ClientData.getPlayer(), AABB.m_165882_((Vec3)ClientData.getPlayer().m_20182_(), (double)this.maxDistance, (double)this.maxDistance, (double)this.maxDistance)).forEach(entity -> this.renderDebug((Entity)entity, poseStack, multiBufferSource));
    }

    protected void renderDebug(Entity entity, PoseStack poseStack, MultiBufferSource multiBufferSource) {
        String[] entityType = entity.m_6095_().toString().split("[.]");
        if (!(this.match.isEmpty() || this.match.contains("") || this.match.contains(entityType[entityType.length - 1]))) {
            return;
        }
        Vec3 pos = entity.m_20182_();
        Vec3 cameraPos = this.cameraPosition();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder consumer = tesselator.m_85915_();
        consumer.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.lineWidth((float)2.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_).m_85950_(1.0f, 0.0f, 0.0f, 1.0f);
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)cameraPos.f_82479_, (float)cameraPos.f_82480_ - 0.5f, (float)cameraPos.f_82481_).m_85950_(1.0f, 0.0f, 0.0f, 1.0f);
        poseStack.m_85849_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)consumer.m_231175_());
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        float distance = (float)pos.m_82546_(cameraPos).m_82553_();
        float y = (float)(pos.f_82480_ + (double)entity.m_20206_()) + distance / 10.0f;
        float scale = distance / 100.0f / 2.0f;
        DebugRenderer.m_269439_((PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (String)entity.m_6095_().toString(), (double)pos.f_82479_, (double)(y + 0.2f), (double)pos.f_82481_, (int)Color.WHITE.getRGB(), (float)scale, (boolean)true, (float)0.0f, (boolean)true);
    }

    @Override
    public void renderGUI() {
        float[] newValue = new float[]{this.maxDistance};
        ImGui.sliderFloat("Max Distance", newValue, 0.0f, 1000.0f);
        this.maxDistance = Mth.m_14036_((float)newValue[0], (float)0.0f, (float)1000.0f);
        String previousState = String.join((CharSequence)";", this.match);
        ImString matchString = new ImString();
        matchString.set(previousState);
        ImGui.inputText("Match (Split with ;)", matchString);
        if (!matchString.get().equals(previousState)) {
            this.match.clear();
            String[] split = matchString.get().split(";");
            this.match.addAll(Arrays.asList(split));
        }
    }

    @Override
    protected void fromPacket(FriendlyByteBuf buf) {
    }
}

