/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.events;

import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.refractionapi.refraction.events.LevelRenderContext;
import net.refractionapi.refraction.events.RefractionEvent;
import net.refractionapi.refraction.events.RefractionEventCaller;
import net.refractionapi.refraction.gui.cli.CLI;
import net.refractionapi.refraction.mixininterfaces.IParticleEngine;

public class RefractionClientEvents {
    public static final RefractionEvent<RenderContext> BEFORE_ENTITIES = new RefractionEventCaller<RenderContext>(RenderContext.class, listeners -> context -> {
        if (context == null) {
            return;
        }
        for (RenderContext listener : listeners) {
            listener.onRender(context);
        }
    });
    public static final RefractionEvent<RenderContext> POST_ALL = new RefractionEventCaller<RenderContext>(RenderContext.class, listeners -> context -> {
        if (context == null) {
            return;
        }
        for (RenderContext listener : listeners) {
            listener.onRender(context);
        }
    });
    public static final RefractionEvent<RegisterParticles> REGISTER_PARTICLES = new RefractionEventCaller<RegisterParticles>(RegisterParticles.class, listeners -> engine -> {
        for (RegisterParticles listener : listeners) {
            listener.onRegister(engine);
        }
    });
    public static final RefractionEvent<Generic> CLIENT_PLAYER_LEAVE = new RefractionEventCaller<Generic>(Generic.class, listeners -> () -> {
        for (Generic listener : listeners) {
            listener.onEvent();
        }
    });
    public static final RefractionEvent<Generic> CLIENT_PLAYER_JOIN = new RefractionEventCaller<Generic>(Generic.class, listeners -> () -> {
        for (Generic listener : listeners) {
            listener.onEvent();
        }
    });
    public static final RefractionEvent<NamedChannelOpen> NAMED_CHANNEL_OPEN = new RefractionEventCaller<NamedChannelOpen>(NamedChannelOpen.class, listeners -> (id, uuid) -> {
        for (NamedChannelOpen listener : listeners) {
            listener.onOpen(id, uuid);
        }
    });
    public static final RefractionEvent<RegisterCLI> CLI_REGISTER = new RefractionEventCaller<RegisterCLI>(RegisterCLI.class, listeners -> cli -> {
        for (RegisterCLI listener : listeners) {
            listener.register(cli);
        }
    });

    @FunctionalInterface
    public static interface RegisterCLI {
        public void register(CLI var1);
    }

    @FunctionalInterface
    public static interface NamedChannelOpen {
        public void onOpen(ResourceLocation var1, UUID var2);
    }

    @FunctionalInterface
    public static interface Generic {
        public void onEvent();
    }

    @FunctionalInterface
    public static interface RegisterParticles {
        public void onRegister(IParticleEngine var1);
    }

    @FunctionalInterface
    public static interface RenderContext {
        public void onRender(LevelRenderContext var1);
    }
}

