/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.events;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.LevelAccessor;
import net.refractionapi.refraction.events.RefractionEvent;
import net.refractionapi.refraction.events.RefractionEventCaller;
import net.refractionapi.refraction.feature.atda.IAtdaProvider;
import net.refractionapi.refraction.feature.channel.NamedAPI;

public interface RefractionEvents {
    public static final RefractionEvent<LoadLevel> LOAD_LEVEL = new RefractionEventCaller<LoadLevel>(LoadLevel.class, listeners -> world -> {
        for (LoadLevel listener : listeners) {
            listener.onLoad(world);
        }
    });
    public static final RefractionEvent<CommonTick> COMMON_TICK = new RefractionEventCaller<CommonTick>(CommonTick.class, listeners -> (server, post) -> {
        for (CommonTick listener : listeners) {
            listener.onTick(server, post);
        }
    });
    public static final RefractionEvent<Tick> SERVER_TICK = new RefractionEventCaller<Tick>(Tick.class, listeners -> post -> {
        COMMON_TICK.invoker().onTick(true, post);
        for (Tick listener : listeners) {
            listener.onTick(post);
        }
    });
    public static final RefractionEvent<Tick> CLIENT_TICK = new RefractionEventCaller<Tick>(Tick.class, listeners -> post -> {
        COMMON_TICK.invoker().onTick(false, post);
        for (Tick listener : listeners) {
            listener.onTick(post);
        }
    });
    public static final RefractionEvent<LevelTick> LEVEL_TICK = new RefractionEventCaller<LevelTick>(LevelTick.class, listeners -> (world, post) -> {
        for (LevelTick listener : listeners) {
            listener.onTick(world, post);
        }
    });
    public static final RefractionEvent<ServerStopping> SERVER_STOPPING = new RefractionEventCaller<ServerStopping>(ServerStopping.class, listeners -> () -> {
        for (ServerStopping listener : listeners) {
            listener.onStop();
        }
    });
    public static final RefractionEvent<ServerEvent> SERVER_STARTING = new RefractionEventCaller<ServerEvent>(ServerEvent.class, listeners -> server -> {
        for (ServerEvent listener : listeners) {
            listener.onStart(server);
        }
    });
    public static final RefractionEvent<ServerEvent> SERVER_STARTED = new RefractionEventCaller<ServerEvent>(ServerEvent.class, listeners -> server -> {
        for (ServerEvent listener : listeners) {
            listener.onStart(server);
        }
    });
    public static final RefractionEvent<PlayerJoin> PLAYER_JOINED = new RefractionEventCaller<PlayerJoin>(PlayerJoin.class, listeners -> player -> {
        for (PlayerJoin listener : listeners) {
            listener.onJoin(player);
        }
    });
    public static final RefractionEvent<RegisterCommands> REGISTER_COMMANDS = new RefractionEventCaller<RegisterCommands>(RegisterCommands.class, listeners -> stack -> {
        for (RegisterCommands listener : listeners) {
            listener.register((CommandDispatcher<CommandSourceStack>)stack);
        }
    });
    public static final RefractionEvent<RegisterAtda> REGISTER_ATDA = new RefractionEventCaller<RegisterAtda>(RegisterAtda.class, listeners -> provider -> {
        for (RegisterAtda listener : listeners) {
            listener.register(provider);
        }
    });
    public static final RefractionEvent<PlayerClone> PLAYER_CLONE = new RefractionEventCaller<PlayerClone>(PlayerClone.class, listeners -> (current, old) -> {
        for (PlayerClone listener : listeners) {
            listener.clone(current, old);
        }
    });
    public static final RefractionEvent<CLIServer> REGISTER_CLI = new RefractionEventCaller<CLIServer>(CLIServer.class, listeners -> channel -> {
        for (CLIServer listener : listeners) {
            listener.configure(channel);
        }
    });

    @FunctionalInterface
    public static interface CLIServer {
        public void configure(NamedAPI var1);
    }

    @FunctionalInterface
    public static interface PlayerClone {
        public void clone(ServerPlayer var1, ServerPlayer var2);
    }

    @FunctionalInterface
    public static interface RegisterAtda {
        public void register(IAtdaProvider var1);
    }

    @FunctionalInterface
    public static interface RegisterCommands {
        public void register(CommandDispatcher<CommandSourceStack> var1);
    }

    @FunctionalInterface
    public static interface PlayerJoin {
        public void onJoin(ServerPlayer var1);
    }

    @FunctionalInterface
    public static interface ServerEvent {
        public void onStart(MinecraftServer var1);
    }

    @FunctionalInterface
    public static interface ServerStopping {
        public void onStop();
    }

    @FunctionalInterface
    public static interface LevelTick {
        public void onTick(LevelAccessor var1, boolean var2);
    }

    @FunctionalInterface
    public static interface Tick {
        public void onTick(boolean var1);
    }

    @FunctionalInterface
    public static interface CommonTick {
        public void onTick(boolean var1, boolean var2);
    }

    @FunctionalInterface
    public static interface LoadLevel {
        public void onLoad(LevelAccessor var1);
    }
}

