/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.algorithm;

import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.refractionapi.refraction.helper.vec3.Vec3Helper;

public class FloodFiller {
    protected final Level level;
    protected BlockPos origin;
    protected int maxSpread = 64;
    protected BiPredicate<BlockState, BlockPos> predicate = (state, pos) -> !state.m_60795_();
    protected BiConsumer<BlockState, BlockPos> postAdd = (state, pos) -> {};
    protected Direction[] directions = FloodFiller.all();

    protected FloodFiller(Level level, BlockPos origin) {
        this.level = level;
        this.origin = origin;
    }

    public FloodFiller setMaxSpread(int size) {
        this.maxSpread = size;
        return this;
    }

    public FloodFiller testCase(BiPredicate<BlockState, BlockPos> predicate) {
        this.predicate = predicate;
        return this;
    }

    public FloodFiller setDirections(Direction ... directions) {
        this.directions = directions;
        return this;
    }

    public FloodFiller postAdd(BiConsumer<BlockState, BlockPos> postAdd) {
        this.postAdd = postAdd;
        return this;
    }

    public FloodFill floodFill(BlockPos origin) {
        this.origin = origin;
        return this.floodFill();
    }

    public FloodFill floodFill() {
        Stream.Builder<BlockInfo> builder = Stream.builder();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        LinkedList<BlockPos> visited = new LinkedList<BlockPos>();
        queue.add(this.origin);
        visited.add(this.origin);
        int xMax = this.origin.m_123341_() + this.maxSpread;
        int yMax = this.origin.m_123342_() + this.maxSpread;
        int zMax = this.origin.m_123343_() + this.maxSpread;
        int xMin = this.origin.m_123341_() - this.maxSpread;
        int yMin = this.origin.m_123342_() - this.maxSpread;
        int zMin = this.origin.m_123343_() - this.maxSpread;
        while (!queue.isEmpty()) {
            BlockPos pos = (BlockPos)queue.poll();
            visited.add(pos);
            BlockState state = this.level.m_8055_(pos);
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            if (x < xMin || x > xMax || y < yMin || y > yMax || z < zMin || z > zMax || !this.predicate.test(state, pos)) continue;
            builder.accept(new BlockInfo(state, pos));
            this.postAdd.accept(state, pos);
            for (Direction direction : this.directions) {
                BlockPos offset = pos.m_121945_(direction);
                if (queue.contains(offset) || visited.contains(offset)) continue;
                queue.add(offset);
            }
        }
        return new FloodFill(builder.build().toList());
    }

    public static Direction[] all() {
        return Direction.values();
    }

    public static Direction[] vertical() {
        return new Direction[]{Direction.DOWN, Direction.UP};
    }

    public static Direction[] horizontal() {
        return new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    }

    public static FloodFiller create(Level level, BlockPos origin) {
        return new FloodFiller(level, origin);
    }

    public record FloodFill(List<BlockInfo> blocks) {
        public AABB createBoundingBox() {
            BlockPos min = this.blocks.get((int)0).pos;
            BlockPos max = this.blocks.get((int)0).pos;
            for (BlockInfo block : this.blocks) {
                BlockPos pos = block.pos;
                min = Vec3Helper.min(min, pos);
                max = Vec3Helper.max(max, pos);
            }
            return new AABB(min, max);
        }

        public BlockPos getCenter() {
            return BlockPos.m_274446_((Position)this.createBoundingBox().m_82399_());
        }
    }

    public record BlockInfo(BlockState state, BlockPos pos) {
    }
}

