/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.algorithm;

import java.util.ArrayList;
import java.util.List;
import jdk.jfr.Experimental;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;

@Experimental
@ApiStatus.Internal
public class MazeGenerator {
    private final int gridSize = 5;
    private int mazeSize;
    private int[][] maze;
    private int wallHeight;
    private int centerSize;
    private int wallThickness;
    private BlockPos start;
    private Direction startDirection;
    private BlockState wallBlock;
    private BlockState wallOuterBlock;
    private BlockState floorBlock;
    private BlockState ceilingBlock;
    private Level level;
    private int[][][] tiles = new int[][][]{new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}}, new int[][]{{0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}}, new int[][]{{0, 0, 0, 0, 0}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}}, new int[][]{{1, 1, 1, 1, 0}, {1, 1, 1, 1, 0}, {1, 1, 1, 0, 0}, {1, 1, 0, 0, 0}, {0, 0, 0, 0, 0}}, new int[][]{{0, 1, 1, 1, 1}, {0, 1, 1, 1, 1}, {0, 0, 1, 1, 1}, {0, 0, 0, 1, 1}, {0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0}, {1, 1, 0, 0, 0}, {1, 1, 1, 0, 0}, {1, 1, 1, 1, 0}, {1, 1, 1, 1, 0}}, new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 1, 1}, {0, 1, 1, 1, 1}, {0, 1, 1, 1, 1}}, new int[][]{{1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}}, new int[][]{{0, 0, 0, 1, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {0, 0, 0, 1, 1}}, new int[][]{{0, 0, 0, 0, 0}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}}, new int[][]{{1, 1, 0, 0, 0}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {1, 1, 0, 0, 0}}, new int[][]{{1, 0, 0, 0, 1}, {0, 0, 1, 0, 0}, {0, 1, 1, 1, 0}, {0, 0, 1, 0, 0}, {1, 0, 0, 0, 1}}};

    public MazeGenerator(Level level) {
        if (level.f_46443_) {
            throw new IllegalArgumentException("Cannot generate maze on the client side");
        }
        this.level = level;
    }

    public MazeGenerator setMazeSize(int mazeSize) {
        this.mazeSize = mazeSize;
        return this;
    }

    public MazeGenerator setWallHeight(int wallHeight) {
        this.wallHeight = wallHeight;
        return this;
    }

    public MazeGenerator setWallThickness(int wallThickness) {
        this.wallThickness = wallThickness;
        return this;
    }

    public MazeGenerator setCenterSize(int centerSize) {
        this.centerSize = centerSize;
        return this;
    }

    public MazeGenerator setStart(BlockPos start, Direction startDirection) {
        this.start = start;
        this.startDirection = startDirection;
        return this;
    }

    public MazeGenerator setWallBlock(BlockState wallBlock) {
        this.wallBlock = wallBlock;
        return this;
    }

    public MazeGenerator setWallOuterBlock(BlockState wallOuterBlock) {
        this.wallOuterBlock = wallOuterBlock;
        return this;
    }

    public MazeGenerator setFloorBlock(BlockState floorBlock) {
        this.floorBlock = floorBlock;
        return this;
    }

    public MazeGenerator setCeilingBlock(BlockState ceilingBlock) {
        this.ceilingBlock = ceilingBlock;
        return this;
    }

    public void generate() {
        this.generateMaze();
        this.fillMaze();
    }

    private void generateMaze() {
        this.maze = new int[this.mazeSize][this.mazeSize];
        for (int i = 0; i < this.mazeSize; ++i) {
            for (int j = 0; j < this.mazeSize; ++j) {
                this.maze[i][j] = -1;
            }
        }
        this.waveFunctionCollapse();
    }

    private void waveFunctionCollapse() {
        ArrayList<int[]> positions = new ArrayList<int[]>();
        for (int i = 0; i < this.mazeSize; ++i) {
            int j = 0;
            while (j < this.mazeSize) {
                positions.add(new int[]{i, j++});
            }
        }
        RandomSource random = this.level.f_46441_;
        while (!positions.isEmpty()) {
            int y;
            int[] pos = (int[])positions.remove(random.m_188503_(positions.size()));
            int x = pos[0];
            List<Integer> possibleTiles = this.getPossibleTiles(x, y = pos[1]);
            if (!possibleTiles.isEmpty()) {
                this.maze[x][y] = possibleTiles.get(random.m_188503_(possibleTiles.size()));
                continue;
            }
            this.maze[x][y] = 0;
        }
    }

    private List<Integer> getPossibleTiles(int x, int y) {
        ArrayList<Integer> possibleTiles = new ArrayList<Integer>();
        for (int tile = 0; tile < this.tiles.length; ++tile) {
            if (!this.isValidTile(x, y, tile)) continue;
            possibleTiles.add(tile);
        }
        return possibleTiles;
    }

    private boolean isValidTile(int x, int y, int tile) {
        return true;
    }

    private void fillMaze() {
        for (int i = 0; i < this.mazeSize; ++i) {
            for (int j = 0; j < this.mazeSize; ++j) {
                int tile = this.maze[i][j];
                if (tile < 0 || tile >= this.tiles.length) continue;
                this.fillTile(i, j, this.tiles[tile]);
            }
        }
    }

    private void fillTile(int x, int y, int[][] tile) {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                int h;
                int blockX = x * 5 + i;
                int blockZ = y * 5 + j;
                int blockY = this.start.m_123342_();
                if (tile[i][j] == 1) {
                    for (h = 0; h < this.wallHeight; ++h) {
                        this.level.m_46597_(new BlockPos(blockX, blockY, blockZ), this.wallBlock);
                    }
                    continue;
                }
                for (h = 0; h < this.wallHeight; ++h) {
                    this.level.m_46597_(new BlockPos(blockX, blockY + h, blockZ), this.wallBlock);
                }
            }
        }
    }
}

