/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.atda;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.refractionapi.refraction.Refraction;
import net.refractionapi.refraction.events.RefractionEvents;
import net.refractionapi.refraction.feature.atda.AtdaData;
import net.refractionapi.refraction.feature.atda.AtdaProvider;
import net.refractionapi.refraction.feature.atda.IAtdaProvider;
import net.refractionapi.refraction.helper.clazz.RModRegistrar;

public class Atda<E, D extends AtdaData<D>> {
    static final ConcurrentHashMap<ResourceLocation, Atda<?, ?>> data = new ConcurrentHashMap();
    final ConcurrentHashMap<E, List<IAtdaProvider>> providers = new ConcurrentHashMap();
    final HashMap<String, AtdaData<?>> clientLookup = new HashMap();
    final ResourceLocation id;
    final Class<E> clazz;

    private Atda(Class<E> clazz, ResourceLocation identifier) {
        this.clazz = clazz;
        this.id = identifier;
    }

    public void add(E obj, IAtdaProvider provider) {
        if (!this.clazz.isInstance(obj)) {
            return;
        }
        if (provider instanceof AtdaProvider) {
            AtdaProvider atdaProvider = (AtdaProvider)provider;
            atdaProvider.setType(this.clazz);
        }
        this.providers.computeIfAbsent(obj, k -> new ArrayList()).add(provider);
        this.getRaw(obj);
    }

    public static <O, D extends AtdaData<D>> Atda<O, D> register(Class<O> clazz, String id) {
        return Atda.register(clazz, RModRegistrar.getCallerModID(2), id);
    }

    public static <O, D extends AtdaData<D>> Atda<O, D> register(Class<O> clazz, String modId, String id) {
        return Atda.register(clazz, ResourceLocation.m_214293_((String)modId, (String)id));
    }

    public static <O, D extends AtdaData<D>> Atda<O, D> register(Class<O> clazz, ResourceLocation location) {
        if (data.containsKey(location)) {
            throw new RuntimeException("Atda already registered %s".formatted(location));
        }
        return data.computeIfAbsent(location, rl -> new Atda(clazz, (ResourceLocation)rl));
    }

    public static <T> void registerProvider(Class<T> clazz, Consumer<T> consumer) {
        RefractionEvents.REGISTER_ATDA.register(provider -> {
            if (clazz.isInstance(provider)) {
                consumer.accept(clazz.cast(provider));
            }
        });
    }

    public static <O, D extends AtdaData<D>> D getRaw(Atda<O, D> holder, O lookup) {
        Atda<?, ?> proper = data.get(holder.id);
        if (proper == null) {
            throw new IllegalArgumentException("Atda not registered %s".formatted(holder.id));
        }
        return (D)proper.internalGet(lookup);
    }

    public static <O, D extends AtdaData<D>> Optional<D> get(Atda<O, D> holder, O look) {
        return Optional.ofNullable(Atda.getRaw(holder, look));
    }

    public Optional<D> get(E lookup) {
        return Atda.get(this, lookup);
    }

    public D getRaw(E lookup) {
        return Atda.getRaw(this, lookup);
    }

    private <O> D internalGet(O lookup) {
        if (!(lookup instanceof IAtdaProvider)) {
            throw new RuntimeException("Invalid lookup called for non-IAtdaProvider class %s".formatted(lookup.getClass().toString()));
        }
        IAtdaProvider lookupProvider = (IAtdaProvider)lookup;
        if (lookupProvider.getLevel().f_46443_) {
            return (D)this.clientLookup.get(lookupProvider.getSyncID());
        }
        for (IAtdaProvider iAtdaProvider : Atda.safeGet(lookup)) {
            AtdaProvider provider;
            Optional data = iAtdaProvider.getAtda(this);
            if (!data.isPresent()) continue;
            ((AtdaData)data.get()).setSyncables(lookupProvider, this);
            return (D)(iAtdaProvider instanceof AtdaProvider ? ((provider = (AtdaProvider)iAtdaProvider).readOnly(lookup) ? provider.copyData() : (AtdaData)data.get()) : (AtdaData)data.get());
        }
        return null;
    }

    public static Atda<?, ?> fromMap(ResourceLocation id) {
        return data.get(id);
    }

    public static <O> void tickProviders(O lookup) {
        Atda.safeGet(lookup).stream().filter(provider -> provider instanceof AtdaProvider).forEach(provider -> {
            if (((AtdaProvider)provider).isValid(lookup)) {
                ((AtdaProvider)provider).tickInternal(lookup);
            }
        });
    }

    public static <O> List<IAtdaProvider> safeGet(O lookup) {
        return data.values().stream().map(atda -> atda.clazz.isInstance(lookup) ? (List)atda.providers.getOrDefault(lookup, new ArrayList()) : new ArrayList()).reduce(new ArrayList(), (a, b) -> {
            a.addAll(b);
            return a;
        });
    }

    public static <O> CompoundTag serializeAll(O lookup) {
        CompoundTag tag = new CompoundTag();
        ListTag listTag = new ListTag();
        data.forEach((resourceLocation, atda) -> {
            if (atda.providers.containsKey(lookup)) {
                CompoundTag atdaData = new CompoundTag();
                atdaData.m_128359_("refraction_atda_reserved_data_fragment", atda.id.toString());
                for (IAtdaProvider iAtdaProvider : atda.providers.get(lookup)) {
                    CompoundTag serialized = new CompoundTag();
                    iAtdaProvider.serialize(serialized);
                    atdaData.m_128365_(iAtdaProvider.getClass().getName(), (Tag)serialized);
                }
                listTag.add((Object)atdaData);
            }
        });
        tag.m_128365_("refraction_atda", (Tag)listTag);
        return tag;
    }

    public static <O> void deserializeAll(O lookup, CompoundTag tag) {
        if (tag == null || !tag.m_128441_("refraction_reserved_atda")) {
            return;
        }
        CompoundTag serializedData = tag.m_128469_("refraction_reserved_atda");
        ListTag listTag = serializedData.m_128437_("refraction_atda", 10);
        if (listTag == null || listTag.isEmpty()) {
            return;
        }
        for (Tag t : listTag) {
            CompoundTag compoundTag = (CompoundTag)t;
            ResourceLocation location = ResourceLocation.m_135820_((String)compoundTag.m_128461_("refraction_atda_reserved_data_fragment"));
            Atda<?, ?> atda = data.get(location);
            if (atda == null) {
                Refraction.LOGGER.warn("Atda not registered {}", (Object)location);
                continue;
            }
            for (IAtdaProvider iAtdaProvider : atda.providers.get(lookup)) {
                iAtdaProvider.deserialize(compoundTag.m_128469_(iAtdaProvider.getClass().getName()));
            }
        }
    }
}

