/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.atda;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.refractionapi.refraction.feature.atda.Atda;
import net.refractionapi.refraction.feature.atda.AtdaData;
import net.refractionapi.refraction.feature.atda.IAtdaProvider;
import net.refractionapi.refraction.helper.misc.GenericBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class AtdaProvider<E, D extends AtdaData<D>>
implements IAtdaProvider,
GenericBuilder<D> {
    private D data;
    private Class<E> clazz;

    protected abstract Atda<E, D> getHolder();

    private D getData() {
        return (D)(this.data == null ? (this.data = (AtdaData)this.build()) : this.data);
    }

    public void setType(Class<?> clazz) {
        this.clazz = clazz;
    }

    public boolean isValid(Object o) {
        return this.clazz != null && this.clazz.isInstance(o);
    }

    public D copyData() {
        AtdaData copy = (AtdaData)this.build();
        copy.copyFrom(this.getData());
        return (D)copy;
    }

    public D data(E lookup) {
        return this.readOnly(lookup) ? this.copyData() : this.getData();
    }

    @ApiStatus.Internal
    public <O> void tickInternal(O obj) {
        if (this.getData() == null || this.data == null || ((AtdaData)this.data).atdaSync == null || ((AtdaData)this.data).providerSync == null) {
            return;
        }
        this.tick(obj);
    }

    public void tick(E obj) {
    }

    public <O> boolean readOnly(O obj) {
        return false;
    }

    @Override
    @NotNull
    public <O, D extends AtdaData<D>> Optional<D> getAtda(Atda<O, D> holder) {
        return holder == this.getHolder() ? Optional.of(this.getData()) : Optional.empty();
    }

    @Override
    public void serialize(CompoundTag tag) {
        ((AtdaData)this.getData()).save(tag);
    }

    @Override
    public void deserialize(CompoundTag tag) {
        D data = this.getData();
        if (((AtdaData)data).first) {
            ((AtdaData)data).onFirstLoad(tag);
            ((AtdaData)data).first = false;
        }
        ((AtdaData)data).load(tag);
    }
}

