/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.atda;

import net.minecraft.world.level.Level;
import net.refractionapi.refraction.feature.atda.Atda;
import net.refractionapi.refraction.feature.atda.AtdaData;
import net.refractionapi.refraction.feature.atda.IAtdaProvider;
import net.refractionapi.refraction.mixininterfaces.IEntity;
import net.refractionapi.refraction.mixininterfaces.ILevel;

public class AtdaUtils {
    public static <O, D extends AtdaData<D>> void onClone(O original, O clone, Atda<O, D> holder) {
        if (original instanceof IEntity) {
            IEntity originalEntity = (IEntity)original;
            if (clone instanceof IEntity) {
                IEntity cloneEntity = (IEntity)clone;
                originalEntity.getAtda(holder).ifPresent(data -> cloneEntity.getAtda(holder).ifPresent(cloneData -> cloneData.copyFrom(data)));
            }
        }
    }

    public static <O, I extends IAtdaProvider> void attachAtda(O entity, Atda<O, ?> holder, I provider) {
        IEntity atda;
        if (entity instanceof IEntity && (atda = (IEntity)entity).getAtda(holder).isEmpty()) {
            atda.addData(holder, provider);
        }
    }

    public static <O extends Level, I extends IAtdaProvider> void attachAtda(O level, Atda<O, ?> holder, I provider) {
        ILevel atda;
        if (level instanceof ILevel && (atda = (ILevel)level).getAtda(holder).isEmpty()) {
            atda.addData(holder, provider);
        }
    }
}

