/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.channel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.refractionapi.refraction.client.ClientData;
import net.refractionapi.refraction.events.RefractionClientEvents;
import net.refractionapi.refraction.events.RefractionEvents;
import net.refractionapi.refraction.feature.channel.SyncConfig;
import net.refractionapi.refraction.feature.channel.ThreadedAPI;
import net.refractionapi.refraction.feature.channel.TwoWayChannel;
import net.refractionapi.refraction.feature.channel.TwoWayIntermediary;
import net.refractionapi.refraction.feature.data.Syncable;
import net.refractionapi.refraction.util.Side;

public class NamedAPI
implements Syncable<NamedAPI> {
    private static final ThreadLocal<HashMap<ResourceLocation, UUID>> channels = ThreadLocal.withInitial(HashMap::new);
    private final SyncConfig syncConfig;
    private final ResourceLocation api;
    private final List<SidedConfigurer> configurer = new ArrayList<SidedConfigurer>();
    private Consumer<NamedAPI> preConfigure;
    private TwoWayChannel channel;

    private NamedAPI(ResourceLocation apiID) {
        this.preConfigure = nap -> {};
        this.api = apiID;
        this.setSynced();
        this.syncConfig = new SyncConfig().setSyncer(this::sync);
    }

    public NamedAPI() {
        this.preConfigure = nap -> {};
        this.api = null;
        this.syncConfig = null;
    }

    public ResourceLocation id() {
        return this.api;
    }

    public NamedAPI configure(Consumer<TwoWayChannel> consumer) {
        this.configurer.add(new SidedConfigurer(Side.COMMON, consumer));
        return this;
    }

    public NamedAPI configureServer(Consumer<TwoWayChannel> consumer) {
        this.configurer.add(new SidedConfigurer(Side.SERVER, consumer));
        return this;
    }

    public NamedAPI configureClient(Consumer<TwoWayChannel> consumer) {
        this.configurer.add(new SidedConfigurer(Side.CLIENT, consumer));
        return this;
    }

    public NamedAPI preConfigure(Consumer<NamedAPI> consumer) {
        this.preConfigure = consumer;
        return this;
    }

    public static NamedAPI initOnServerStart(NamedAPI api) {
        RefractionEvents.SERVER_STARTING.register(server -> api.open((Level)server.m_129783_()));
        return api;
    }

    public NamedAPI initOnServerStart() {
        return NamedAPI.initOnServerStart(this);
    }

    public static NamedAPI initOnOpen(NamedAPI namedAPI) {
        RefractionClientEvents.NAMED_CHANNEL_OPEN.register((api, id) -> {
            if (api.equals((Object)namedAPI.api)) {
                namedAPI.open(ClientData.getPlayer().m_9236_(), id);
            }
        });
        return namedAPI;
    }

    public NamedAPI initOnOpen() {
        return NamedAPI.initOnOpen(this);
    }

    public ThreadedAPI initCommon() {
        return new ThreadedAPI(this);
    }

    public NamedAPI open(Level level) {
        this.channel = new TwoWayChannel(level);
        this.postOpen(level);
        return this;
    }

    public NamedAPI open(Level level, UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("UUID cannot be null");
        }
        this.channel = new TwoWayChannel(level, uuid);
        this.postOpen(level);
        return this;
    }

    protected void postOpen(Level level) {
        this.preConfigure.accept(this);
        this.configurer.forEach(sidedConfigurer -> {
            if (sidedConfigurer.side.equals((Object)Side.COMMON)) {
                sidedConfigurer.configurer.accept(this.channel);
                return;
            }
            if (level.f_46443_ && sidedConfigurer.side.equals((Object)Side.CLIENT)) {
                sidedConfigurer.configurer.accept(this.channel);
            } else if (!level.f_46443_ && sidedConfigurer.side.equals((Object)Side.SERVER)) {
                sidedConfigurer.configurer.accept(this.channel);
            }
        });
        this.syncAllServer((LevelAccessor)level);
        this.channel.open();
        channels.get().put(this.api, this.channel.id());
    }

    public NamedAPI open(Level level, ResourceLocation api) {
        return this.open(level, NamedAPI.getChannel(api));
    }

    public void close() {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public TwoWayChannel channel() {
        return this.channel;
    }

    public static UUID getChannel(ResourceLocation id) {
        return channels.get().get(id);
    }

    public static HashMap<ResourceLocation, UUID> channels() {
        return NamedAPI.channels();
    }

    public static Optional<ResourceLocation> getChannel(UUID id) {
        return channels.get().entrySet().stream().filter(entry -> ((UUID)entry.getValue()).equals(id)).findFirst().map(Map.Entry::getKey);
    }

    public static void removeChannel(ResourceLocation rl) {
        channels.get().remove(rl);
    }

    public static void sendToServer(ResourceLocation id, String router, TwoWayChannel.Data data, TwoWayChannel.Header header) {
        HashMap<ResourceLocation, UUID> map = channels.get();
        UUID channel = map.get(id);
        if (channel != null) {
            TwoWayIntermediary.instance(false).sendTo(false, router, channel, data, header, null);
        }
    }

    public static void sendToServer(ResourceLocation id, String router, TwoWayChannel.Data data) {
        NamedAPI.sendToServer(id, router, data, null);
    }

    public static void sendToServer(ResourceLocation id, String router, TwoWayChannel.Header header) {
        NamedAPI.sendToServer(id, router, null, header);
    }

    public static void sendToServer(ResourceLocation id, String router) {
        NamedAPI.sendToServer(id, router, null, null);
    }

    public static NamedAPI create(ResourceLocation id) {
        return new NamedAPI(id);
    }

    protected static NamedAPI create(NamedAPI api) {
        NamedAPI namedAPI = new NamedAPI(api.api);
        namedAPI.configurer.addAll(api.configurer);
        namedAPI.preConfigure = api.preConfigure;
        return namedAPI;
    }

    public static void clear() {
        channels.get().clear();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        HashMap<ResourceLocation, UUID> map = channels.get();
        buf.writeInt(map.size());
        map.entrySet().removeIf(entry -> entry.getKey() == null || entry.getValue() == null);
        map.forEach((key, value) -> {
            buf.m_130085_(key);
            buf.m_130077_(value);
        });
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        HashMap<ResourceLocation, UUID> map = channels.get();
        HashMap mapOld = new HashMap(channels.get());
        map.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            map.put(buf.m_130281_(), buf.m_130259_());
        }
        map.entrySet().stream().filter(entry -> !mapOld.containsKey(entry.getKey())).forEach(entry -> RefractionClientEvents.NAMED_CHANNEL_OPEN.invoker().onOpen((ResourceLocation)entry.getKey(), (UUID)entry.getValue()));
    }

    static {
        RefractionClientEvents.CLIENT_PLAYER_LEAVE.register(() -> channels.get().clear());
    }

    public record SidedConfigurer(Side side, Consumer<TwoWayChannel> configurer) {
    }
}

