/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.channel;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.refractionapi.refraction.Refraction;
import net.refractionapi.refraction.feature.channel.NamedAPI;
import net.refractionapi.refraction.feature.channel.TwoWayIntermediary;
import net.refractionapi.refraction.networking.RefractionMessages;
import net.refractionapi.refraction.networking.S2C.TwoWayS2CPacket;
import net.refractionapi.refraction.util.Mutable;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public class TwoWayChannel {
    private static final String DEFAULT = "default";
    protected final UUID channelID;
    protected Status status = Status.CLOSED;
    protected Rule rule = Rule.ALL;
    protected Header HEADER = (router, buf) -> {};
    protected OnReceive onReceive = (player, routerID, header, buf) -> {};
    protected ConcurrentHashMap<String, Router> ROUTERS = new ConcurrentHashMap();
    protected ServerPlayer owner = null;
    protected TriFunction<Player, FriendlyByteBuf, String, Boolean> valid = (player, buf, router) -> true;
    protected Function<ServerPlayer, Boolean> canCommunicate = player -> this.owner == null || player == this.owner;
    protected boolean closeOnTerminate = false;
    protected final Level level;
    @Nullable
    protected ReceivedHeader receivedHeader;
    protected Predicate<ServerPlayer> canSendTo = player -> true;
    protected boolean sendOnly = false;
    protected int id;
    protected final Int2ObjectArrayMap<Message> messages = new Int2ObjectArrayMap();

    public TwoWayChannel(Level level) {
        this(level, UUID.randomUUID());
    }

    public TwoWayChannel(Level level, UUID channelID) {
        this.channelID = channelID;
        this.level = level;
    }

    public UUID id() {
        return this.channelID;
    }

    public TwoWayChannel owner(Entity owner) {
        if (!(owner instanceof ServerPlayer)) {
            throw new IllegalArgumentException("Owner must be a player");
        }
        ServerPlayer player = (ServerPlayer)owner;
        this.owner = player;
        this.rule(Rule.OWNER);
        return this;
    }

    public TwoWayChannel router(String id, @Nullable Listener listener, @Nullable Sender sender) {
        this.ROUTERS.put(id, new Router(id, listener, sender));
        return this;
    }

    public TwoWayChannel registerListener(String id, Listener listener) {
        this.ROUTERS.compute(id, (k, v) -> v == null ? new Router(id, listener, null) : new Router(id, listener, v.sender));
        return this;
    }

    public TwoWayChannel registerSender(String id, Sender sender) {
        this.ROUTERS.compute(id, (k, v) -> v == null ? new Router(id, null, sender) : new Router(id, v.listener, sender));
        return this;
    }

    public TwoWayChannel registerListener(Listener listener) {
        return this.registerListener(DEFAULT, listener);
    }

    public TwoWayChannel registerSender(Sender sender) {
        return this.registerSender(DEFAULT, sender);
    }

    public TwoWayChannel router(Listener listener, Sender sender) {
        return this.router(DEFAULT, listener, sender);
    }

    public TwoWayChannel router(String id, Listener listener) {
        return this.router(id, listener, null);
    }

    public String[] routes() {
        return (String[])this.ROUTERS.keySet().toArray(String[]::new);
    }

    public TwoWayChannel valid(TriFunction<Player, FriendlyByteBuf, String, Boolean> valid) {
        this.valid = valid;
        return this;
    }

    public TwoWayChannel canSendTo(Predicate<ServerPlayer> canSendTo) {
        this.canSendTo = canSendTo;
        return this;
    }

    public TwoWayChannel canCommunicate(Function<ServerPlayer, Boolean> canCommunicate) {
        this.canCommunicate = canCommunicate;
        return this;
    }

    public TwoWayChannel header(Header header) {
        this.HEADER = header;
        return this;
    }

    public TwoWayChannel onRecieve(OnReceive onReceive) {
        this.onReceive = onReceive;
        return this;
    }

    public ReceivedHeader header() {
        return this.receivedHeader;
    }

    public TwoWayChannel rule(Rule rule) {
        if (rule.equals((Object)Rule.OWNER) && this.owner == null) {
            throw new IllegalStateException("Owner must be set before setting rule to OWNER");
        }
        this.rule = rule;
        return this;
    }

    public TwoWayChannel setSendOnly() {
        this.sendOnly = true;
        return this;
    }

    public ServerPlayer owner() {
        return this.owner;
    }

    public TwoWayChannel open() {
        if (this.isOpen()) {
            throw new IllegalStateException("Channel is already open");
        }
        if (this.channelID == null) {
            throw new IllegalStateException("Listener ID must be set before opening channel");
        }
        this.status = this.owner == null ? Status.OPEN : Status.COMMUNICATING;
        this.instance().addChannel(this);
        return this;
    }

    public TwoWayChannel close() {
        if (this.isClosed()) {
            return this;
        }
        this.status = Status.CLOSED;
        TwoWayIntermediary instance = this.instance();
        if (this.isServer()) {
            this.terminate();
        }
        instance.CHANNELS.remove(this.channelID);
        return this;
    }

    public TwoWayIntermediary instance() {
        return TwoWayIntermediary.instance(!this.level.f_46443_);
    }

    public void terminate() {
        if (this.level.f_46443_) {
            throw new UnsupportedOperationException("Cannot terminate channel on client side");
        }
        this.instance().terminate(this.channelID);
        NamedAPI.getChannel(this.channelID).ifPresent(NamedAPI::removeChannel);
    }

    public TwoWayChannel closeOnTerminate() {
        this.closeOnTerminate = true;
        return this;
    }

    protected TwoWayChannel setCommunicating() {
        if (this.isClosed()) {
            throw new IllegalStateException("Channel is closed");
        }
        this.status = Status.COMMUNICATING;
        return this;
    }

    public boolean isOpen() {
        return this.status == Status.OPEN;
    }

    public boolean isCommunicating() {
        return this.status == Status.COMMUNICATING;
    }

    public boolean isClosed() {
        return this.status == Status.CLOSED;
    }

    public boolean isServer() {
        return !this.level.f_46443_;
    }

    public boolean send(String routerID, Data data, Header header, Rule.RuleConsumer rule) {
        if (this.isClosed()) {
            return false;
        }
        this.instance().sendTo(!this.level.f_46443_, routerID, this.channelID, data, header, rule);
        ++this.id;
        return true;
    }

    public boolean send(Player player, String routerID, Data data, Header header) {
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer s = (ServerPlayer)player;
        return this.send(routerID, data, header, (TwoWayChannel c, UUID uuid, FriendlyByteBuf headerBuf, FriendlyByteBuf dataBuf, Predicate<ServerPlayer> ignored) -> RefractionMessages.sendToPlayer(new TwoWayS2CPacket(uuid, headerBuf, dataBuf), s));
    }

    public boolean send(String routerID, Data data, Header header) {
        return this.send(routerID, data, header, null);
    }

    public boolean send(String routerID, Data data) {
        return this.send(routerID, data, this.HEADER);
    }

    public boolean send(String routerID, Header header) {
        return this.send(routerID, null, header);
    }

    public boolean send(String routerID) {
        return this.send(routerID, null, null);
    }

    public boolean send() {
        return this.send(DEFAULT);
    }

    public void post(String routerID, Header header, Data data, OnReceive onRespond) {
        if (!this.level.f_46443_) {
            Refraction.LOGGER.error("Server usage of POST packets is explicitly forbidden!");
            return;
        }
        int sentID = this.id;
        Header idAble = (id, h) -> {
            h.m_128359_("post-r-set", "post-r-set");
            h.m_128405_("post-r-id", this.id);
            header.message(routerID, h);
        };
        this.send(routerID, data, idAble);
        if (++sentID != this.id) {
            return;
        }
        ((Message)this.messages.get((int)(--sentID))).onRespond.set(Optional.of(onRespond));
    }

    public void respond(ReceivedHeader header, Data data) {
        CompoundTag headerBuf = header.header();
        String post = headerBuf.m_128461_("post-r-set");
        int id = headerBuf.m_128451_("post-r-id");
        if (!post.equals("post-r-set")) {
            return;
        }
        this.send(header.player, header.router, data, (String i, CompoundTag buf) -> {
            buf.m_128379_("post-r-res", true);
            buf.m_128405_("post-r-id", id);
        });
    }

    private boolean handleRespond(Player player, String routerID, FriendlyByteBuf buf, CompoundTag receivedHeaderTag) {
        int id = receivedHeaderTag.m_128451_("post-r-id");
        if (receivedHeaderTag.m_128441_("post-r-res")) {
            if (player instanceof ServerPlayer) {
                ServerPlayer s = (ServerPlayer)player;
                s.f_8906_.m_9942_((Component)Component.m_237113_((String)"Illegal packet"));
                Refraction.LOGGER.info("Player {} sent an illegal packet (POST protocol)", (Object)player.m_5446_().getString());
                return false;
            }
            assert (this.messages.containsKey(id)) : "ScreenMessage ID doesn't exist %d".formatted(id);
            ((Message)this.messages.get(id)).onRespond().get().ifPresent(c -> c.message(player, routerID, this.receivedHeader, new FriendlyByteBuf(buf.copy())));
            this.messages.remove(id);
            return true;
        }
        return false;
    }

    public void receive(@Nullable Player player, String routerID, FriendlyByteBuf header, FriendlyByteBuf buf) {
        if (this.isServer() && this.sendOnly && player != null) {
            Refraction.LOGGER.warn("Player {} tried sending a packet to a send-only channel", (Object)player.m_5446_().getString());
            return;
        }
        this.receivedHeader = new ReceivedHeader(routerID, player, header.m_130260_());
        if (this.isClosed() || !this.isCommunicating() || !((Boolean)this.valid.apply((Object)player, (Object)new FriendlyByteBuf(buf.copy()), (Object)routerID)).booleanValue()) {
            return;
        }
        if (this.handleRespond(player, routerID, buf, this.receivedHeader.header)) {
            return;
        }
        Router router = this.ROUTERS.get(routerID);
        if (router == null) {
            Refraction.LOGGER.warn("Received message for unknown router: {}", (Object)routerID);
            return;
        }
        if (router.listener == null) {
            return;
        }
        this.onReceive.message(player, routerID, this.receivedHeader, new FriendlyByteBuf(buf.copy()));
        router.listener.handle(player, buf);
    }

    public boolean message(String routerID, FriendlyByteBuf buf) {
        if (this.isClosed()) {
            return false;
        }
        Router router = this.ROUTERS.get(routerID);
        if (router == null || router.sender == null) {
            return false;
        }
        router.sender.message(buf);
        return true;
    }

    public static enum Status {
        OPEN,
        COMMUNICATING,
        CLOSED;

    }

    public static enum Rule {
        ALL((channel, uuid, header, buf, predicate) -> channel.level.m_7654_().m_6846_().m_11314_().stream().filter(predicate).forEach(p -> RefractionMessages.sendToPlayer(new TwoWayS2CPacket(uuid, header, buf), p))),
        OWNER((channel, uuid, header, buf, predicate) -> RefractionMessages.sendToPlayer(new TwoWayS2CPacket(uuid, header, buf), predicate.test(channel.owner) ? channel.owner : null));

        final RuleConsumer syncer;

        private Rule(RuleConsumer syncer) {
            this.syncer = syncer;
        }

        @FunctionalInterface
        public static interface RuleConsumer {
            public void accept(TwoWayChannel var1, UUID var2, FriendlyByteBuf var3, FriendlyByteBuf var4, Predicate<ServerPlayer> var5);
        }
    }

    @FunctionalInterface
    public static interface Header {
        public void message(String var1, CompoundTag var2);
    }

    @FunctionalInterface
    public static interface OnReceive {
        public void message(Player var1, String var2, ReceivedHeader var3, FriendlyByteBuf var4);
    }

    public record Router(String id, Listener listener, Sender sender) {
    }

    @FunctionalInterface
    public static interface Listener {
        public int handle(Player var1, FriendlyByteBuf var2);
    }

    @FunctionalInterface
    public static interface Sender {
        public void message(FriendlyByteBuf var1);
    }

    public record ReceivedHeader(String router, Player player, CompoundTag header) {
    }

    @FunctionalInterface
    public static interface Data {
        public void message(FriendlyByteBuf var1);
    }

    public record Message(int id, String router, FriendlyByteBuf data, FriendlyByteBuf header, Mutable<Optional<OnReceive>> onRespond) {
        private final FriendlyByteBuf data;
        private final FriendlyByteBuf header;

        public FriendlyByteBuf data() {
            return new FriendlyByteBuf(this.data.copy());
        }

        public FriendlyByteBuf header() {
            return new FriendlyByteBuf(this.header.copy());
        }
    }
}

