/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.channel;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.refractionapi.refraction.feature.channel.NamedAPI;
import net.refractionapi.refraction.feature.channel.SyncConfig;
import net.refractionapi.refraction.feature.channel.TwoWayChannel;
import net.refractionapi.refraction.feature.data.Syncable;
import net.refractionapi.refraction.networking.C2S.TwoWayC2SPacket;
import net.refractionapi.refraction.networking.RefractionMessages;
import net.refractionapi.refraction.util.Mutable;
import net.refractionapi.refraction.util.Pair;

public class TwoWayIntermediary
implements Syncable<TwoWayIntermediary> {
    protected static TwoWayIntermediary[] INSTANCE = new TwoWayIntermediary[2];
    protected SyncConfig syncConfig = new SyncConfig().setSyncer(this::sync);
    protected final ConcurrentHashMap<UUID, Optional<TwoWayChannel>> CHANNELS = new ConcurrentHashMap();

    public TwoWayIntermediary() {
        this(0);
    }

    public TwoWayIntermediary(int index) {
        if (INSTANCE[index] == null) {
            TwoWayIntermediary.INSTANCE[index] = this;
        }
        this.setSynced();
    }

    public void addChannel(TwoWayChannel channel) {
        this.CHANNELS.put(channel.id(), Optional.of(channel));
        if (!channel.level.f_46443_) {
            this.syncConfig.syncAll((ServerLevel)channel.level);
        }
    }

    public void sendTo(boolean isServer, String routerID, UUID uuid, TwoWayChannel.Data data, TwoWayChannel.Header header, TwoWayChannel.Rule.RuleConsumer rule, boolean terminated) {
        Optional<TwoWayChannel> channel = this.CHANNELS.get(uuid);
        if (channel == null) {
            return;
        }
        channel.ifPresent(c -> {
            boolean msg;
            FriendlyByteBuf headerBuf = new FriendlyByteBuf(Unpooled.buffer());
            CompoundTag headerTag = new CompoundTag();
            FriendlyByteBuf msgBuf = new FriendlyByteBuf(Unpooled.buffer());
            msgBuf.writeBoolean(terminated);
            msgBuf.m_130070_(routerID);
            boolean bl = msg = c.message(routerID, msgBuf) || data != null;
            if (data != null) {
                data.message(msgBuf);
            }
            if (!msg) {
                return;
            }
            if (header != null) {
                header.message(routerID, headerTag);
            } else {
                c.HEADER.message(routerID, headerTag);
            }
            headerBuf.m_130079_(headerTag);
            c.messages.put(c.id, (Object)new TwoWayChannel.Message(c.id, routerID, new FriendlyByteBuf(msgBuf.copy()), new FriendlyByteBuf(headerBuf.copy()), new Mutable<Optional<TwoWayChannel.OnReceive>>(Optional.empty())));
            if (!isServer) {
                RefractionMessages.sendToServer(new TwoWayC2SPacket(uuid, headerBuf, msgBuf));
            } else if (rule == null) {
                c.rule.syncer.accept((TwoWayChannel)c, uuid, headerBuf, msgBuf, c.canSendTo);
            } else {
                rule.accept((TwoWayChannel)c, uuid, headerBuf, msgBuf, c.canSendTo);
            }
        });
    }

    public void read(Player player, UUID uuid, FriendlyByteBuf header, FriendlyByteBuf buf) {
        Optional<TwoWayChannel> channel = this.CHANNELS.get(uuid);
        if (channel == null) {
            return;
        }
        channel.ifPresent(c -> {
            ServerPlayer serverPlayer;
            boolean terminated = buf.readBoolean();
            String routerID = buf.m_130277_();
            if (terminated && !c.isServer()) {
                if (c.closeOnTerminate) {
                    c.close();
                }
                this.CHANNELS.remove(uuid);
                NamedAPI.getChannel(uuid).ifPresent(NamedAPI::removeChannel);
                return;
            }
            if (player instanceof ServerPlayer && !c.canCommunicate.apply(serverPlayer = (ServerPlayer)player).booleanValue()) {
                return;
            }
            c.setCommunicating();
            c.receive(player, routerID, header, buf);
            c.receivedHeader = null;
        });
    }

    public void sendTo(boolean isServer, String router, UUID uuid, TwoWayChannel.Data data, TwoWayChannel.Header header, TwoWayChannel.Rule.RuleConsumer rule) {
        this.sendTo(isServer, router, uuid, data, header, rule, false);
    }

    public void sendTo(boolean isServer, String router, UUID uuid) {
        this.sendTo(isServer, router, uuid, null, null, null, false);
    }

    protected void terminate(UUID uuid) {
        this.sendTo(true, "", uuid, null, null, null, true);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        for (UUID uuid : this.CHANNELS.keySet()) {
            buf.m_130077_(uuid);
        }
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        while (buf.isReadable()) {
            this.CHANNELS.computeIfAbsent(buf.m_130259_(), uuid -> Optional.empty());
        }
    }

    public void reset() {
        this.CHANNELS.clear();
        NamedAPI.clear();
    }

    public List<Pair<UUID, Optional<TwoWayChannel>>> channels() {
        return List.copyOf(this.CHANNELS.entrySet().stream().map(entry -> new Pair<UUID, Optional>((UUID)entry.getKey(), (Optional)entry.getValue())).toList());
    }

    public HashMap<UUID, Optional<TwoWayChannel>> hashChannels() {
        return new HashMap<UUID, Optional<TwoWayChannel>>(this.CHANNELS);
    }

    public static TwoWayIntermediary instance(boolean isServer) {
        int index = isServer ? 0 : 1;
        return INSTANCE[index] == null ? new TwoWayIntermediary(index) : INSTANCE[index];
    }

    public static void init(MinecraftServer server) {
        if (server.m_129920_()) {
            new TwoWayIntermediary();
        }
    }
}

