/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.cutscenes;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.phys.Vec3;
import net.refractionapi.refraction.feature.cutscenes.CutsceneHandler;
import net.refractionapi.refraction.feature.cutscenes.point.PointHandler;
import net.refractionapi.refraction.helper.math.EasingFunctions;
import net.refractionapi.refraction.helper.vec3.Vec3Helper;
import net.refractionapi.refraction.networking.RefractionMessages;
import net.refractionapi.refraction.networking.S2C.InvokeCutsceneS2CPacket;
import net.refractionapi.refraction.networking.S2C.SetBarPropsS2CPacket;
import net.refractionapi.refraction.networking.S2C.SetFOVS2CPacket;
import net.refractionapi.refraction.networking.S2C.SetZRotS2CPacket;

public class Cutscene {
    public final LivingEntity livingEntity;
    public Vec3 playerTPPos;
    protected final List<PointHandler> points = new ArrayList<PointHandler>();
    public ArmorStand camera;
    public boolean forced;
    public boolean started = false;
    public boolean stopped = false;
    protected Consumer<Cutscene> beforeStop;
    protected Consumer<Cutscene> afterStop;
    protected Consumer<Cutscene> cameraTick;
    protected Consumer<Cutscene> generalCameraTick;
    protected Consumer<Cutscene> afterSwitch;
    public Vec3 spawnPoint = Vec3.f_82478_;
    public Vec3 target = Vec3.f_82478_;
    public boolean invulnerable = true;
    protected boolean lockedPosition = true;
    public boolean lockedCamera = true;
    protected boolean lockedLook = true;
    protected final boolean defaultBars;
    public Vec3 lookAt;

    protected Cutscene(LivingEntity livingEntity, Vec3 lookAt, boolean forced, boolean defaultBars) {
        this.livingEntity = livingEntity;
        this.forced = forced;
        this.defaultBars = defaultBars;
        this.lookAt = lookAt;
        this.hideName(true);
    }

    public void tick() {
        PointHandler current;
        if (this.generalCameraTick != null) {
            this.generalCameraTick.accept(this);
        }
        if (this.cameraTick != null) {
            this.cameraTick.accept(this);
        }
        if (this.points.isEmpty()) {
            this.stop();
            return;
        }
        if (this.lockedLook) {
            this.livingEntity.m_7618_(EntityAnchorArgument.Anchor.EYES, this.lookAt);
        }
        if (this.lockedPosition) {
            this.livingEntity.m_6021_(this.playerTPPos.f_82479_, this.playerTPPos.f_82480_, this.playerTPPos.f_82481_);
        }
        if (!(current = this.points.get(0)).isSwitched()) {
            current.onSwitch();
        }
        current.tickPoints();
        if (current.getTransitionTime() <= 0 && current.getLockedTime() <= 0) {
            this.points.remove(0);
        }
    }

    protected void start() {
        this.playerTPPos = this.livingEntity.m_20182_();
        this.createCamera();
        this.started = true;
        LivingEntity livingEntity = this.livingEntity;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            RefractionMessages.sendToPlayer(new InvokeCutsceneS2CPacket(this.camera.m_19879_(), true), serverPlayer);
            if (this.defaultBars) {
                RefractionMessages.sendToPlayer(new SetBarPropsS2CPacket(true, 0, 50, 0.0f, 0.0f, 15, EasingFunctions.LINEAR), serverPlayer);
            }
        }
    }

    public void stop() {
        ServerPlayer serverPlayer;
        LivingEntity livingEntity;
        if (this.afterStop != null) {
            this.afterStop.accept(this);
        }
        if (this.camera != null) {
            this.camera.m_146870_();
        }
        if ((livingEntity = this.livingEntity) instanceof ServerPlayer && CutsceneHandler.QUEUE.get(serverPlayer = (ServerPlayer)livingEntity).isEmpty()) {
            RefractionMessages.sendToPlayer(new InvokeCutsceneS2CPacket(-1, false), serverPlayer);
            RefractionMessages.sendToPlayer(new SetFOVS2CPacket(-1), serverPlayer);
            RefractionMessages.sendToPlayer(new SetZRotS2CPacket(-1.0f), serverPlayer);
            RefractionMessages.sendToPlayer(new SetBarPropsS2CPacket(false, 0, 0, 0.0f, 0.0f, 0, EasingFunctions.LINEAR), serverPlayer);
            this.hideName(false);
        }
        this.stopped = true;
    }

    public static void stopAll(LivingEntity livingEntity) {
        if (CutsceneHandler.QUEUE.containsKey(livingEntity)) {
            for (Cutscene cutscene : CutsceneHandler.QUEUE.get(livingEntity)) {
                cutscene.stop();
            }
        }
    }

    public Cutscene afterStop(Consumer<Cutscene> afterStop) {
        this.afterStop = afterStop;
        return this;
    }

    public Cutscene beforeStop(Consumer<Cutscene> beforeStop) {
        this.beforeStop = beforeStop;
        return this;
    }

    public Cutscene tickCamera(Consumer<Cutscene> cameraTick) {
        this.cameraTick = cameraTick;
        return this;
    }

    public Cutscene generalCameraTick(Consumer<Cutscene> generalCameraTick) {
        this.generalCameraTick = generalCameraTick;
        return this;
    }

    public Cutscene afterSwitch(Consumer<Cutscene> afterSwitch) {
        this.afterSwitch = afterSwitch;
        return this;
    }

    public Cutscene lockPosition(boolean lock) {
        this.lockedPosition = lock;
        return this;
    }

    public Cutscene lockCamera(boolean lock) {
        this.lockedCamera = lock;
        return this;
    }

    public Cutscene hideName(boolean hide) {
        this.livingEntity.m_20340_(hide);
        return this;
    }

    public Cutscene setInvulnerable(boolean invulnerable) {
        this.invulnerable = invulnerable;
        return this;
    }

    public Cutscene lockLook(boolean lock) {
        this.lockedLook = lock;
        return this;
    }

    public void createCamera() {
        this.camera = new ArmorStand(this.livingEntity.m_9236_(), this.spawnPoint.f_82479_, this.spawnPoint.f_82480_, this.spawnPoint.f_82481_);
        this.camera.m_146884_(this.spawnPoint);
        this.camera.m_7618_(EntityAnchorArgument.Anchor.EYES, this.target);
        this.camera.m_6842_(true);
        this.camera.m_20331_(true);
        this.camera.m_20242_(true);
        this.camera.m_20340_(false);
        this.livingEntity.m_9236_().m_7967_((Entity)this.camera);
    }

    public PointHandler createPoint(int transitionTime, int lockedTime) {
        PointHandler pointHandler = new PointHandler(this, transitionTime, lockedTime);
        this.points.add(pointHandler);
        return pointHandler;
    }

    public static Cutscene create(LivingEntity livingEntity, Vec3 lookAt, boolean forced, boolean defaultBars) {
        return new Cutscene(livingEntity, lookAt, forced, defaultBars);
    }

    public static Cutscene create(LivingEntity livingEntity, Vec3 lookAt, boolean forced) {
        return Cutscene.create(livingEntity, lookAt, forced, true);
    }

    public static Cutscene create(LivingEntity livingEntity, boolean forced, boolean defaultBars) {
        return Cutscene.create(livingEntity, Vec3Helper.getVec(livingEntity, 1.0f, 0.0f), forced, defaultBars);
    }

    public static Cutscene create(LivingEntity livingEntity, boolean forced) {
        return Cutscene.create(livingEntity, forced, true);
    }

    public static Cutscene create(LivingEntity livingEntity) {
        return Cutscene.create(livingEntity, false);
    }

    public static Vec3 rightEye(LivingEntity livingEntity) {
        Vec3 vec3 = livingEntity.m_146892_();
        Vec3 vec31F = Vec3Helper.calculateViewVector(0.0f, livingEntity.m_146908_()).m_82490_((double)0.1f);
        Vec3 vec31S = Vec3Helper.calculateViewVector(0.0f, livingEntity.m_146908_() + 90.0f).m_82490_((double)0.15f);
        Vec3 FBVector = vec3.m_82549_(vec31F);
        Vec3 RLVector = vec3.m_82549_(vec31S);
        Vec3 vectorDifference = FBVector.m_82546_(RLVector);
        return vec3.m_82549_(vectorDifference);
    }

    public static Vec3 leftEye(LivingEntity livingEntity) {
        Vec3 vec3 = livingEntity.m_146892_();
        Vec3 vec31F = Vec3Helper.calculateViewVector(0.0f, livingEntity.m_146908_()).m_82490_((double)0.1f);
        Vec3 vec31S = Vec3Helper.calculateViewVector(0.0f, livingEntity.m_146908_() + 90.0f).m_82490_((double)-0.15f);
        Vec3 FBVector = vec3.m_82549_(vec31F);
        Vec3 RLVector = vec3.m_82549_(vec31S);
        Vec3 vectorDifference = FBVector.m_82546_(RLVector);
        return vec3.m_82549_(vectorDifference);
    }
}

