/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.cutscenes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.LivingEntity;
import net.refractionapi.refraction.events.RefractionEvents;
import net.refractionapi.refraction.feature.cutscenes.Cutscene;

public class CutsceneHandler {
    public static final HashMap<LivingEntity, List<Cutscene>> QUEUE = new HashMap();

    public static boolean inCutscene(LivingEntity livingEntity) {
        return QUEUE.containsKey(livingEntity) && !QUEUE.get(livingEntity).isEmpty();
    }

    public static void init() {
        RefractionEvents.SERVER_TICK.register(post -> {
            Iterator<Map.Entry<LivingEntity, List<Cutscene>>> mapIterator = QUEUE.entrySet().iterator();
            while (mapIterator.hasNext()) {
                Map.Entry<LivingEntity, List<Cutscene>> entry = mapIterator.next();
                List<Cutscene> cutscenes = entry.getValue();
                if (cutscenes.isEmpty()) {
                    mapIterator.remove();
                    continue;
                }
                Cutscene cutscene = cutscenes.get(0);
                if (cutscenes.size() > 1 && cutscene.points.isEmpty()) {
                    cutscene.stop();
                    cutscenes.remove(0);
                    cutscene = cutscenes.get(0);
                    cutscene.start();
                    continue;
                }
                if (cutscene == null) continue;
                if (cutscene.livingEntity.m_21224_()) {
                    Cutscene.stopAll(cutscene.livingEntity);
                    continue;
                }
                if (!cutscene.started) {
                    cutscene.start();
                }
                cutscene.tick();
                if (!cutscene.stopped) continue;
                if (cutscene.beforeStop != null) {
                    cutscene.beforeStop.accept(cutscene);
                }
                cutscenes.remove(0);
                cutscene.stop();
            }
        });
        RefractionEvents.SERVER_STOPPING.register(() -> QUEUE.forEach((player, cutscenes) -> {
            for (Cutscene cutscene : cutscenes) {
                cutscene.stop();
            }
        }));
    }
}

