/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.data;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.refractionapi.refraction.feature.data.Syncable;
import org.apache.commons.lang3.function.TriFunction;

public class ClientSyncer<T extends Syncable<?>> {
    public static final HashMap<Class<? extends Syncable<?>>, ClientSyncer<?>> SERIALIZERS = new HashMap();
    private static final HashMap<Class<? extends Syncable<?>>, TriFunction<Integer, FriendlyByteBuf, FriendlyByteBuf, ? extends Syncable<?>>> interceptors = new HashMap();
    private final HashMap<Integer, T> cache = new HashMap();
    private final Class<T> clazz;

    public ClientSyncer(Class<?> clazz) {
        this.clazz = clazz;
    }

    public static void handle(Class<?> clazz, int id, FriendlyByteBuf buf, FriendlyByteBuf constArgs) {
        SERIALIZERS.computeIfAbsent(clazz, s -> new ClientSyncer(clazz)).handleSerializer(clazz, id, buf, constArgs);
    }

    public <C> void handleSerializer(Class<C> clazz, int id, FriendlyByteBuf buf, FriendlyByteBuf constArgs) {
        Syncable interceptor;
        if (interceptors.containsKey(clazz) && (interceptor = (Syncable)interceptors.get(clazz).apply((Object)id, (Object)buf, (Object)constArgs)) != null) {
            interceptor.onSync(buf, id);
            return;
        }
        this.cache.computeIfAbsent(id, i -> {
            T byteBuf = this.createConstructed(clazz, constArgs);
            return byteBuf == null ? this.createEmpty(clazz) : byteBuf;
        }).onSync(buf, id);
    }

    public static <C extends Syncable<C>> void setInterceptor(Class<C> clazz, TriFunction<Integer, FriendlyByteBuf, FriendlyByteBuf, C> output) {
        interceptors.put(clazz, output);
    }

    private T createEmpty(Class<T> clazz) {
        try {
            return (T)((Syncable)clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InstantiationError("Failed to instantiate class %s, no valid constructor found".formatted(clazz.getName()));
        }
    }

    private T createConstructed(Class<T> clazz, FriendlyByteBuf buf) {
        try {
            return (T)((Syncable)clazz.getConstructor(FriendlyByteBuf.class).newInstance(buf));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ignored) {
            return null;
        }
    }
}

