/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.data;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.refractionapi.refraction.feature.data.Syncable;
import net.refractionapi.refraction.networking.S2C.SerializerS2CPacket;
import net.refractionapi.refraction.platform.RefractionServices;

public class SerializableHandler<C extends Syncable<C>> {
    protected final HashMap<C, Integer> HANDLER = new HashMap();
    protected BiFunction<C, FriendlyByteBuf, Object[]> deserializer = Syncable::deserialize;
    protected BiConsumer<C, FriendlyByteBuf> serializer = Syncable::serialize;

    public Object[] get(C obj, FriendlyByteBuf buf) {
        return buf == null ? new Object[]{} : this.deserializer.apply(obj, buf);
    }

    public <T> SerializableHandler<C> add(T data) {
        this.HANDLER.put((Syncable)data, this.HANDLER.size());
        return this;
    }

    public int getID(C data) {
        return this.HANDLER.getOrDefault(data, -1);
    }

    public void sync(Syncable<?> data, Entity syncTo) {
        if (syncTo instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)syncTo;
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            FriendlyByteBuf constArgs = new FriendlyByteBuf(Unpooled.buffer());
            this.serializer.accept(data, constArgs);
            data.write(buf);
            RefractionServices.MESSAGES.sendPlayer(new SerializerS2CPacket(data.getClass(), this.HANDLER.get(data), buf, constArgs), serverPlayer);
        }
    }

    public static Class<?>[] formClassArray(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            classes[i] = objects[i].getClass();
        }
        return classes;
    }
}

