/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.data;

import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.refractionapi.refraction.feature.data.SerializableHandler;

public interface Syncable<C extends Syncable<C>> {
    public static final ConcurrentHashMap<Class<? extends Syncable<?>>, SerializableHandler<?>> serializers = new ConcurrentHashMap();

    default public void sync(Entity sync) {
        if (!serializers.containsKey(this.getClass()) || !Syncable.serializers.get(this.getClass()).HANDLER.containsKey(this)) {
            throw new IllegalStateException("this.setSynced() has not been called in a constructor for %s".formatted(this.getClass().getName()));
        }
        serializers.get(this.getClass()).sync(this, sync);
    }

    default public void syncAll(Level level) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (ServerPlayer player : serverLevel.m_6907_()) {
            this.sync((Entity)player);
        }
    }

    default public void syncAllServer(LevelAccessor accessor) {
        if (!(accessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)accessor;
        for (ServerPlayer player : serverLevel.m_7654_().m_6846_().m_11314_()) {
            this.sync((Entity)player);
        }
    }

    default public int getSyncID() {
        return this.syncableHandler().getID(this);
    }

    default public SerializableHandler<C> syncableHandler() {
        if (!serializers.containsKey(this.getClass())) {
            throw new IllegalStateException("this.setSynced() has not been called in a constructor for %s".formatted(this.getClass().getName()));
        }
        return serializers.get(this.getClass());
    }

    default public SerializableHandler<C> setSynced() {
        return serializers.computeIfAbsent(this.getClass(), c -> new SerializableHandler()).add(this);
    }

    default public void serialize(FriendlyByteBuf buf) {
    }

    default public Object[] deserialize(FriendlyByteBuf buf) {
        return new Object[0];
    }

    public void write(FriendlyByteBuf var1);

    public void read(FriendlyByteBuf var1);

    default public void onSync(FriendlyByteBuf buf, int id) {
        this.read(buf);
    }
}

