/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.examples.interaction;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.refractionapi.refraction.feature.interaction.InteractionStage;
import net.refractionapi.refraction.feature.interaction.NPCInteraction;

public class ExampleInteractionScreen
extends Screen {
    private final NPCInteraction npcInteraction;
    private final HashMap<String, List<Button>> buttons = new HashMap();
    private String currentStage;
    private int ticks;
    protected static final int BORDER = 114;

    public ExampleInteractionScreen(NPCInteraction npcInteraction) {
        super((Component)Component.m_237113_((String)"Example Interaction Screen"));
        this.npcInteraction = npcInteraction;
        this.npcInteraction.init();
        this.currentStage = this.npcInteraction.firstStage().getId();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.npcInteraction.getStages().forEach((id, stage) -> {
            ArrayList stageButtons = new ArrayList();
            stage.getOptions().forEach((component, buttonOptions2) -> {
                Button button = Button.m_253074_((Component)component, onPress -> {
                    stage.onSwitch(buttonOptions2.goTo(), (Component)component);
                    this.switchStage(buttonOptions2.goTo());
                    buttonOptions2.onClick().ifPresent(consumer -> consumer.accept(this.npcInteraction));
                    this.ticks = 0;
                }).m_252794_(this.f_96543_ / 2 + 114 + 10, this.f_96544_ / 2 + stageButtons.size() * 20).m_253136_();
                stageButtons.add(button);
            });
            this.buttons.put((String)id, stageButtons);
        });
        this.switchStage(this.currentStage);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int i = (this.f_96543_ - 192) / 2;
        InteractionStage stage = this.npcInteraction.getStage(this.currentStage);
        float lerp = (float)Math.min(this.ticks, stage.getDialogueTicks()) / (float)stage.getDialogueTicks();
        Component component = stage.getDialogue();
        FormattedText subComponent = FormattedText.m_130775_((String)component.m_6881_().getString().substring(0, (int)((float)component.getString().length() * lerp)));
        List components = this.f_96547_.m_92923_(subComponent, 140);
        this.f_96547_.m_92852_(subComponent);
        for (int l = 0; l < components.size(); ++l) {
            FormattedCharSequence formattedcharsequence = (FormattedCharSequence)components.get(l);
            pGuiGraphics.m_280649_(this.f_96547_, formattedcharsequence, i + 36, this.f_96544_ / 2 + l * 9, Color.WHITE.getRGB(), false);
        }
        if (lerp >= 1.0f && !stage.getGoTo().isEmpty()) {
            stage.onSwitch(stage.getGoTo(), (Component)Component.m_237119_());
            this.switchStage(stage.getGoTo());
            this.ticks = 0;
        }
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void m_86600_() {
        ++this.ticks;
        InteractionStage stage = this.npcInteraction.getStage(this.currentStage);
        if (stage == null) {
            return;
        }
        if (stage.ends() && (stage.getDialogueTicks() + 25 <= this.ticks || stage.shouldInstantlyClose())) {
            stage.onSwitch("", (Component)Component.m_237119_());
            this.m_7379_();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void switchStage(String id) {
        this.buttons.get(this.currentStage).forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.currentStage = id;
        this.buttons.get(this.currentStage).forEach(x$0 -> {
            Button cfr_ignored_0 = (Button)this.m_142416_((GuiEventListener)x$0);
        });
    }
}

