/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.quest;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.refractionapi.refraction.Refraction;
import net.refractionapi.refraction.feature.quest.QuestHandler;
import net.refractionapi.refraction.feature.quest.QuestPart;
import net.refractionapi.refraction.feature.quest.points.QuestPoint;
import net.refractionapi.refraction.networking.RefractionMessages;
import net.refractionapi.refraction.networking.S2C.SyncQuestInfoS2CPacket;

public abstract class Quest {
    private final List<QuestPart> questParts = new ArrayList<QuestPart>();
    private final UUID player;
    private ServerPlayer playerCache;
    private ServerLevel level;
    protected boolean removable = false;
    protected Consumer<Quest> onCompletion;

    public Quest(ServerPlayer player, CompoundTag tag) {
        this.player = player.m_20148_();
        this.level = player.m_284548_();
        this.addToHandler();
        if (tag != null) {
            this.deserializePreGen(tag);
        }
        this.generate();
        if (tag != null) {
            this.deserializeNBT(tag);
        }
    }

    public abstract void generate();

    public abstract Component questName();

    public void addToHandler() {
        if (QuestHandler.QUESTS.containsKey(this.player)) {
            QuestHandler.QUESTS.get(this.player).end(false);
        }
        QuestHandler.QUESTS.put(this.player, this);
    }

    public void tick() {
        if (this.questParts.isEmpty()) {
            this.end(true);
            return;
        }
        QuestPart part = this.questParts.get(0);
        if (part.completed()) {
            if (part.getOnCompletion() != null) {
                part.getOnCompletion().accept(part);
            }
            this.questParts.remove(0);
        } else {
            part.tick();
        }
    }

    public QuestPart newPart(Component description) {
        QuestPart part = new QuestPart(this, description);
        this.questParts.add(part);
        return part;
    }

    public List<QuestPoint> getQuestPoints() {
        ArrayList<QuestPoint> points = new ArrayList<QuestPoint>();
        if (this.questParts.isEmpty()) {
            return points;
        }
        QuestPart part = this.questParts.get(0);
        return part.getQuestPoints();
    }

    public Quest onQuestEnd(Consumer<Quest> onCompletion) {
        this.onCompletion = onCompletion;
        return this;
    }

    public void end(boolean completed) {
        if (completed && this.onCompletion != null) {
            this.onCompletion.accept(this);
        }
        this.questParts.clear();
        RefractionMessages.sendToPlayer(new SyncQuestInfoS2CPacket(false, (Component)Component.m_237119_(), (Component)Component.m_237119_(), List.of(), new CompoundTag()), this.getPlayer());
        this.removable = true;
    }

    public ServerPlayer getPlayer() {
        ServerPlayer serverPlayer = (ServerPlayer)this.level.m_46003_(this.player);
        this.playerCache = serverPlayer == null ? this.playerCache : serverPlayer;
        return this.playerCache;
    }

    public ServerLevel getLevel() {
        this.level = this.getPlayer() == null ? this.level : this.getPlayer().m_284548_();
        return this.level;
    }

    public boolean isCompleted() {
        return this.questParts.isEmpty();
    }

    public void serializeNBT(CompoundTag tag) {
        if (this.questParts.isEmpty()) {
            return;
        }
        CompoundTag questPartTag = new CompoundTag();
        QuestPart questPart = this.questParts.get(0);
        questPartTag.m_128405_("size", this.questParts.size());
        questPartTag.m_128365_("questPartSer", (Tag)questPart.serialize());
        tag.m_128365_("questPart", (Tag)questPartTag);
    }

    protected void deserializeNBT(CompoundTag tag) {
        if (!tag.m_128441_("questPart")) {
            return;
        }
        CompoundTag questPartTag = tag.m_128469_("questPart");
        int size = questPartTag.m_128451_("size");
        int difference = this.questParts.size() - size;
        if (difference > 0) {
            this.questParts.subList(0, difference).clear();
        }
        CompoundTag questPartTagSer = questPartTag.m_128469_("questPartSer");
        this.questParts.get(0).deserialize(questPartTagSer);
    }

    protected void deserializePreGen(CompoundTag tag) {
    }

    public static <T extends Quest> T startQuest(Player player, Class<T> quest, CompoundTag tag) {
        if (!(player instanceof ServerPlayer)) {
            return null;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        try {
            return (T)((Quest)quest.getConstructor(ServerPlayer.class, CompoundTag.class).newInstance(serverPlayer, tag));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Refraction.LOGGER.error("Failed to create quest {}\n{}", quest, (Object)e);
            return null;
        }
    }

    public static <T extends Quest> T startQuest(Player player, Class<T> quest) {
        return Quest.startQuest(player, quest, new CompoundTag());
    }
}

