/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.quest.points;

import java.util.Map;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.refractionapi.refraction.feature.quest.Quest;
import net.refractionapi.refraction.feature.quest.points.QuestPoint;

public class EnchantmentPoint
extends QuestPoint {
    private final Enchantment enchantment;
    private final int minLevel;
    private final int maxLevel;

    public EnchantmentPoint(Quest quest, Enchantment enchantment, int minLevel, int maxLevel) {
        super(quest);
        this.enchantment = enchantment;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    @Override
    public void tick() {
        if (this.quest.getPlayer().m_150109_().f_35974_.stream().anyMatch(itemStack -> {
            Map enchantments = EnchantmentHelper.m_44882_((ListTag)itemStack.m_41785_());
            return enchantments.containsKey(this.enchantment) && (Integer)enchantments.get(this.enchantment) >= this.minLevel && (Integer)enchantments.get(this.enchantment) <= this.maxLevel;
        })) {
            this.completed = true;
        }
    }

    @Override
    public String id() {
        return "%s+%d-%d".formatted(this.enchantment.m_44704_(), this.minLevel, this.maxLevel);
    }

    @Override
    public Component description() {
        return Component.m_237113_((String)"Enchant an item with ").m_7220_((Component)Component.m_237115_((String)this.enchantment.m_44704_())).m_7220_((Component)Component.m_237113_((String)(" %d".formatted(this.minLevel) + (this.maxLevel == this.minLevel ? "" : "-%d".formatted(this.maxLevel)))));
    }
}

