/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.quest.points;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.refractionapi.refraction.feature.quest.Quest;
import net.refractionapi.refraction.feature.quest.points.QuestPoint;

public class KillPoint
extends QuestPoint {
    private EntityType<?> entityType;
    private int amount;
    private int currentAmount = 0;

    public KillPoint(Quest quest, EntityType<?> entityType, int amount) {
        super(quest);
        this.entityType = entityType;
        this.amount = amount;
    }

    @Override
    public void tick() {
    }

    @Override
    public Component description() {
        return Component.m_237113_((String)"Kill: ").m_7220_((Component)Component.m_237115_((String)this.entityType.m_20675_())).m_7220_((Component)Component.m_237113_((String)" %d/%d".formatted(this.currentAmount, this.amount)));
    }

    public void onKill(Entity entity) {
        if (entity.m_6095_().equals(this.entityType)) {
            ++this.currentAmount;
            if (this.currentAmount >= this.amount) {
                this.completed = true;
            }
        }
    }

    @Override
    public String id() {
        return "%s+%d".formatted(this.entityType.m_20675_(), this.amount);
    }

    @Override
    public void serialize(CompoundTag tag) {
        super.serialize(tag);
        tag.m_128359_("entityType", EntityType.m_20613_(this.entityType).toString());
        tag.m_128405_("amount", this.amount);
        tag.m_128405_("currentAmount", this.currentAmount);
    }

    @Override
    public void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        this.entityType = (EntityType)EntityType.m_20632_((String)tag.m_128461_("entityType")).orElseThrow(() -> new RuntimeException("Invalid entity type"));
        this.amount = tag.m_128451_("amount");
        this.currentAmount = tag.m_128451_("currentAmount");
    }
}

