/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.quest.points;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.refractionapi.refraction.feature.quest.Quest;
import net.refractionapi.refraction.feature.quest.points.QuestPoint;

public class LocationPoint
extends QuestPoint {
    private Vec3 point;
    private double radius;

    public LocationPoint(Quest quest, Vec3 point, double radius) {
        super(quest);
        this.point = point;
        this.radius = radius;
    }

    @Override
    public void tick() {
        if (this.quest.getPlayer().m_20238_(this.point) < this.radius * this.radius) {
            this.completed = true;
        }
    }

    @Override
    public Component description() {
        return Component.m_237113_((String)"Go to %.1f %.1f %.1f (%.1f blocks)".formatted(this.point.f_82479_, this.point.f_82480_, this.point.f_82481_, Float.valueOf(Mth.m_14116_((float)((float)this.quest.getPlayer().m_20238_(this.point))))));
    }

    @Override
    public void serialize(CompoundTag tag) {
        super.serialize(tag);
        tag.m_128347_("x", this.point.f_82479_);
        tag.m_128347_("y", this.point.f_82480_);
        tag.m_128347_("z", this.point.f_82481_);
        tag.m_128347_("radius", this.radius);
    }

    @Override
    public String id() {
        return "location";
    }

    @Override
    public void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        this.point = new Vec3(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z"));
        this.radius = tag.m_128459_("radius");
    }
}

