/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.quest.points;

import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.refractionapi.refraction.feature.quest.Quest;

public abstract class QuestPoint {
    protected Quest quest;
    protected boolean completed = false;
    private boolean loaded = false;
    private Consumer<CompoundTag> saveAdditional;
    private Consumer<CompoundTag> onDeserialize;

    public QuestPoint(Quest quest) {
        this.quest = quest;
    }

    public abstract void tick();

    public abstract Component description();

    public abstract String id();

    public String genericID() {
        return this.getClass().getSimpleName();
    }

    public boolean checkCompletion() {
        return this.completed;
    }

    public boolean loaded() {
        return this.loaded;
    }

    public void serialize(CompoundTag tag) {
        tag.m_128379_("completed", this.completed);
        tag.m_128359_("id", this.id());
        tag.m_128359_("genericID", this.genericID());
        if (this.saveAdditional != null) {
            this.saveAdditional.accept(tag);
        }
    }

    public void deserialize(CompoundTag tag) {
        this.completed = tag.m_128471_("completed");
        this.loaded = true;
        if (this.onDeserialize != null) {
            this.onDeserialize.accept(tag);
        }
    }

    public QuestPoint saveAdditional(Consumer<CompoundTag> consumer) {
        this.saveAdditional = consumer;
        return this;
    }

    public QuestPoint onDeserialize(Consumer<CompoundTag> consumer) {
        this.onDeserialize = consumer;
        return this;
    }
}

