/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.reconfig;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.refractionapi.refraction.feature.reconfig.RCBoolean;
import net.refractionapi.refraction.feature.reconfig.RCDouble;
import net.refractionapi.refraction.feature.reconfig.RCInteger;
import net.refractionapi.refraction.feature.reconfig.RCList;
import net.refractionapi.refraction.feature.reconfig.RCMap;
import net.refractionapi.refraction.feature.reconfig.RCString;
import net.refractionapi.refraction.feature.reconfig.ReConfigurer;
import net.refractionapi.refraction.feature.reconfig.ReconfigValue;
import net.refractionapi.refraction.util.Mutable;
import net.refractionapi.refraction.util.Side;

public class RCBuilder {
    private Value[] values = new Value[0];
    private Value current = null;
    protected Side side;
    protected String file;
    protected String name;
    protected boolean syncOnSave = false;

    public RCBuilder set(String name, boolean defaultValue) {
        return this.define(name, "", new RCBoolean(defaultValue));
    }

    public RCBuilder set(String name, String description, boolean defaultValue) {
        return this.define(name, description, new RCBoolean(defaultValue));
    }

    public RCBuilder set(String name, double defaultValue) {
        return this.define(name, "", new RCDouble(defaultValue));
    }

    public RCBuilder set(String name, String description, double defaultValue) {
        return this.define(name, description, new RCDouble(defaultValue));
    }

    public RCBuilder set(String name, int defaultValue) {
        return this.define(name, "", new RCInteger(defaultValue));
    }

    public RCBuilder set(String name, String description, int defaultValue) {
        return this.define(name, description, new RCInteger(defaultValue));
    }

    public RCBuilder set(String name, String defaultValue) {
        return this.define(name, "", new RCString(defaultValue));
    }

    public RCBuilder set(String name, String description, String defaultValue) {
        return this.define(name, description, new RCString(defaultValue));
    }

    public <T extends ReconfigValue<?>> RCBuilder set(String name, Class<T> clazz, List<?> defaultValue) {
        return this.define(name, "", new RCList<T>(clazz, defaultValue));
    }

    public <T extends ReconfigValue<?>> RCBuilder set(String name, String description, Class<T> clazz, List<?> defaultValue) {
        return this.define(name, description, new RCList<T>(clazz, defaultValue));
    }

    public <K extends ReconfigValue<?>, V extends ReconfigValue<?>> RCBuilder set(String name, Class<K> keyClass, Class<V> valueClass, HashMap<K, V> defaultValue) {
        return this.define(name, "", new RCMap<K, V>(keyClass, valueClass, defaultValue));
    }

    public <K extends ReconfigValue<?>, V extends ReconfigValue<?>> RCBuilder set(String name, String description, Class<K> keyClass, Class<V> valueClass, HashMap<K, V> defaultValue) {
        return this.define(name, description, new RCMap<K, V>(keyClass, valueClass, defaultValue));
    }

    public <K extends ReconfigValue<?>, V extends ReconfigValue<?>> RCBuilder set(String name, Class<K> keyClass, Class<V> valueClass, Map<K, V> defaultValue) {
        return this.set(name, "", keyClass, valueClass, new HashMap<K, V>(defaultValue));
    }

    public <K extends ReconfigValue<?>, V extends ReconfigValue<?>> RCBuilder set(String name, String description, Class<K> keyClass, Class<V> valueClass, Map<K, V> defaultValue) {
        return this.set(name, description, keyClass, valueClass, new HashMap<K, V>(defaultValue));
    }

    public <T> RCBuilder check(Predicate<T> valid) {
        this.current.valid().set(valid);
        return this;
    }

    public <T extends ReconfigValue<?>> T build() {
        return this.current.value;
    }

    protected RCBuilder with(Side side, String name, String file) {
        this.side = side;
        this.name = name;
        this.file = file;
        return this;
    }

    protected void save() {
        if (this.file == null) {
            throw new IllegalStateException("Cannot save before config is registered!");
        }
        ReConfigurer.save(this.file, this);
        ReConfigurer.syncCommonConfig(this);
    }

    protected void load() {
        if (this.file == null) {
            throw new IllegalStateException("Cannot load before config is registered!");
        }
        ReConfigurer.load(this.file, this);
    }

    protected <V, T extends ReconfigValue<V>> RCBuilder define(String name, String description, T value) {
        value.setBuilder(this);
        this.current = new Value(new Mutable<String>(name), new Mutable<String>(description), new Mutable(v -> true), value);
        this.addValue(this.current);
        return this;
    }

    protected void addValue(Value<?, ?> value) {
        Value[] newValues = new Value[this.values.length + 1];
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newValues[this.values.length] = value;
        this.values = newValues;
    }

    protected Collection<Value<?, ?>> values() {
        return List.of(this.values);
    }

    protected boolean valueExists(String key) {
        return this.values().stream().anyMatch(value -> value.name().get().equals(key) || key.equals("comment-%s".formatted(value.name.get())));
    }

    public RCBuilder copy() {
        final Value[] valuesCopy = this.values;
        final Value currentCopy = this.current;
        final Side sideCopy = this.side;
        final String fileCopy = this.file;
        final String nameCopy = this.name;
        return new RCBuilder(){
            {
                RCBuilder.this.values = valuesCopy;
                RCBuilder.this.current = currentCopy;
                this.side = sideCopy;
                this.file = fileCopy;
                this.name = nameCopy;
            }
        };
    }

    public record Value<V, T extends ReconfigValue<V>>(Mutable<String> name, Mutable<String> description, Mutable<Predicate<V>> valid, T value) {
    }
}

