/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.reconfig;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import net.refractionapi.refraction.feature.reconfig.ReconfigValue;

public class RCMap<K extends ReconfigValue<?>, V extends ReconfigValue<?>>
extends ReconfigValue<HashMap<K, V>> {
    private final Class<K> keyClass;
    private final Class<V> valueClass;

    public RCMap(Class<K> keyClass, Class<V> valueClass, HashMap<K, V> defaultValue) {
        super(defaultValue);
        this.keyClass = keyClass;
        this.valueClass = valueClass;
    }

    public <C, N> HashMap<C, N> asMap() {
        return ((HashMap)this.loadAndGet()).entrySet().stream().collect(HashMap::new, (map, entry) -> map.put(((ReconfigValue)entry.getKey()).getValue(), ((ReconfigValue)entry.getValue()).getValue()), HashMap::putAll);
    }

    @Override
    public void serialize(String name, JsonObject object) {
        JsonArray array = new JsonArray();
        ((HashMap)this.value).forEach((key, value) -> {
            JsonObject entry = new JsonObject();
            JsonObject keyObject = new JsonObject();
            key.serialize("key", keyObject);
            JsonObject valueObject = new JsonObject();
            value.serialize("value", valueObject);
            entry.add("key", (JsonElement)keyObject);
            entry.add("value", (JsonElement)valueObject);
            array.add((JsonElement)entry);
        });
        object.add(name, (JsonElement)array);
    }

    @Override
    public void deserialize(String name, JsonObject object) {
        if (!object.has(name)) {
            return;
        }
        JsonElement primitive = object.get(name);
        if (!primitive.isJsonArray()) {
            return;
        }
        JsonArray array = primitive.getAsJsonArray();
        ((HashMap)this.value).clear();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject entryObject = array.get(i).getAsJsonObject();
            JsonObject keyObject = entryObject.getAsJsonObject("key");
            JsonObject valueObject = entryObject.getAsJsonObject("value");
            if (keyObject == null || valueObject == null) {
                return;
            }
            Set keys = ((HashMap)this.value).keySet();
            Collection values = ((HashMap)this.value).values();
            K key = keys.size() > i ? (ReconfigValue)keys.stream().skip(i).findFirst().orElse(this.create(this.keyClass)) : this.create(this.keyClass);
            V value = values.size() > i ? (ReconfigValue)values.stream().skip(i).findFirst().orElse(this.create(this.valueClass)) : this.create(this.valueClass);
            ((ReconfigValue)key).deserialize("key", keyObject);
            ((ReconfigValue)value).deserialize("value", valueObject);
            ((HashMap)this.value).put(key, value);
        }
    }

    @Override
    public String type() {
        return "map";
    }
}

