/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.reconfig;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.refractionapi.refraction.Refraction;
import net.refractionapi.refraction.events.RefractionEvents;
import net.refractionapi.refraction.feature.channel.NamedAPI;
import net.refractionapi.refraction.feature.channel.SyncConfig;
import net.refractionapi.refraction.feature.channel.ThreadedAPI;
import net.refractionapi.refraction.feature.channel.TwoWayChannel;
import net.refractionapi.refraction.feature.reconfig.RCBuilder;
import net.refractionapi.refraction.feature.reconfig.ReconfigValue;
import net.refractionapi.refraction.platform.RefractionServices;
import net.refractionapi.refraction.util.FileUtil;
import net.refractionapi.refraction.util.Side;
import org.apache.commons.lang3.function.TriFunction;

public class ReConfigurer {
    private static final LevelResource RECONFIG = FileUtil.createResource("reconfig");
    private static final HashMap<Side, HashMap<String, RCBuilder>> builders = new HashMap();
    public static final ResourceLocation CONFIG = Refraction.id("reconfig");
    protected static ThreadedAPI configurer = NamedAPI.create(CONFIG).configure(channel -> {
        channel.valid((TriFunction<Player, FriendlyByteBuf, String, Boolean>)((TriFunction)(plr, buf, route) -> !channel.isServer()));
        channel.registerSender(ReConfigurer::toClient);
    }).configureClient(channel -> {
        channel.registerListener(ReConfigurer::fromServer);
        channel.registerListener("single", ReConfigurer::fromServer);
        channel.registerListener("reload", (plr, buf) -> ReConfigurer.reload((Side)buf.m_130066_(Side.class), (s, b) -> {}));
    }).initCommon();
    protected static SyncConfig syncConfig = new SyncConfig().setSyncer(entity -> {
        configurer.get().sync(entity);
        ReConfigurer.syncCommonConfigs();
    });

    public static void registerServer(String name, RCBuilder builder) {
        ReConfigurer.put(Side.SERVER, name, builder.with(Side.SERVER, name, ""));
    }

    public static void registerCommon(String name, RCBuilder builder) {
        String file = "./reconfig/%s".formatted(name);
        builder.syncOnSave = true;
        ReConfigurer.put(Side.COMMON, name, builder.with(Side.COMMON, name, file));
        ReConfigurer.registerServer(name, builder);
        ReConfigurer.registerClient(name, builder.copy());
    }

    public static void registerClient(String name, RCBuilder builder) {
        if (!RefractionServices.PLATFORM.isClient()) {
            return;
        }
        String file = "./reconfig/%s".formatted(name);
        ReConfigurer.put(Side.CLIENT, name, builder.with(Side.CLIENT, name, file));
        ReConfigurer.load(file, builder);
    }

    public static int reload(Side side, BiConsumer<String, RCBuilder> onReload) {
        if (side.equals((Object)Side.CLIENT) && configurer.channel().isServer()) {
            configurer.channel().send("reload", buf -> buf.m_130068_((Enum)side));
            return 0;
        }
        builders.get((Object)side).forEach((id, builder) -> {
            builder.load();
            onReload.accept((String)id, (RCBuilder)builder);
        });
        return 1;
    }

    private static void put(Side side, String id, RCBuilder builder) {
        builders.computeIfAbsent(side, s -> new HashMap()).put(id, builder);
        Refraction.LOGGER.info("Registered ReConfig file {} for {}", (Object)id, (Object)side.toString());
    }

    static void saveAll(Side side) {
        ReConfigurer.forSide(side, (info, builder) -> ReConfigurer.save(builder.file, builder));
    }

    static void prepareServerConfigs(MinecraftServer server) {
        ReConfigurer.forSide(Side.SERVER, (info, builder) -> {
            String saveName = "%s/%s".formatted(server.m_129843_(RECONFIG).toString(), builder.name);
            builder.with(Side.SERVER, (String)info, saveName);
        });
    }

    static void prepareCommonConfigs(MinecraftServer server) {
        ReConfigurer.forSide(Side.COMMON, (info, builder) -> {
            String saveName = "%s/%s".formatted(server.m_129843_(RECONFIG).toString(), builder.name);
            builder.with(Side.COMMON, (String)info, saveName);
        });
    }

    static void loadAll(Side side) {
        ReConfigurer.forSide(side, (info, builder) -> ReConfigurer.load(builder.file, builder));
    }

    static void forSide(Side side, BiConsumer<String, RCBuilder> consumer) {
        builders.computeIfAbsent(side, s -> new HashMap()).forEach(consumer);
    }

    static void clearSide(Side side) {
        ReConfigurer.forSide(side, (name, builder) -> {
            builder.file = name;
        });
    }

    private static JsonObject saveObject(File file, JsonObject object) {
        try (FileWriter writer = new FileWriter(file);){
            Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
            gson.toJson((JsonElement)object, (Appendable)writer);
        }
        catch (Exception e) {
            Refraction.LOGGER.error("Failed to save reconfig file {}", (Object)file.getName(), (Object)e);
        }
        return object;
    }

    private static JsonObject getJsonObject(File file) {
        JsonObject jsonObject;
        FileInputStream stream = new FileInputStream(file);
        try {
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream));
            Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
            jsonObject = ((JsonObject)gson.fromJson(reader, TypeToken.get(JsonObject.class))).getAsJsonObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Refraction.LOGGER.error("Failed to load reconfig file {}", (Object)file.getName(), (Object)e);
                return null;
            }
        }
        ((InputStream)stream).close();
        return jsonObject;
    }

    static void save(String file, RCBuilder builder) {
        File location = new File("%s.json5".formatted(file));
        JsonObject object = new JsonObject();
        try {
            builder.values().forEach(value -> {
                if (!value.description().get().isEmpty()) {
                    object.addProperty("comment-%s".formatted(value.name().get()), value.description().get());
                }
                ((ReconfigValue)value.value()).serialize(value.name().get(), object);
            });
            if (!location.exists() && location.getParentFile().mkdirs() && location.createNewFile()) {
                Refraction.LOGGER.info("Created reconfig file {}", (Object)location.getName());
            }
            ReConfigurer.saveObject(location, object);
        }
        catch (Exception e) {
            Refraction.LOGGER.error("Failed to save reconfig file {}", (Object)location.getName(), (Object)e);
        }
    }

    private static JsonObject loadTrimmedJson(String file, RCBuilder builder) {
        File location = new File("%s.json5".formatted(file));
        JsonObject json = ReConfigurer.getJsonObject(location);
        assert (json != null);
        new ConcurrentHashMap<String, JsonElement>(json.asMap()).forEach((name, element) -> {
            if (!builder.valueExists((String)name)) {
                json.remove(name);
            }
        });
        ReConfigurer.saveObject(location, json);
        return json;
    }

    static void load(String file, RCBuilder builder) {
        try {
            File location = new File("%s.json5".formatted(file));
            if (!location.exists()) {
                Refraction.LOGGER.debug("Reconfig file {} does not exist, creating it", (Object)location.getName());
                ReConfigurer.save(file, builder);
                return;
            }
            JsonObject json = ReConfigurer.loadTrimmedJson(file, builder);
            builder.values().forEach(value -> ((ReconfigValue)value.value()).deserialize(value.name().get(), json));
        }
        catch (Exception e) {
            Refraction.LOGGER.error("Couldn't load reconfig file {}", (Object)file, (Object)e);
        }
    }

    static void syncCommonConfigs() {
        configurer.channel().send();
    }

    protected static void syncCommonConfig(RCBuilder builder) {
        if (!builder.syncOnSave) {
            return;
        }
        configurer.channel().send("single", buf -> ReConfigurer.compileConfig(new File("%s.json5".formatted(builder.file)), builder, buf), (routerID, header) -> header.m_128359_("option", "single"));
    }

    static void toClient(FriendlyByteBuf buf) {
        configurer.channel().header((routerID, header) -> header.m_128359_("option", "reconfig"));
        ReConfigurer.forSide(Side.COMMON, (name, builder) -> ReConfigurer.compileConfig(new File("%s.json5".formatted(builder.file)), builder, buf));
    }

    static void compileConfig(File file, RCBuilder builder, FriendlyByteBuf buf) {
        if (!file.exists()) {
            Refraction.LOGGER.error("Reconfig file {} does not exist, cannot send to client", (Object)file.getName());
            return;
        }
        JsonObject obj = ReConfigurer.getJsonObject(file);
        if (obj == null) {
            return;
        }
        buf.m_130070_(builder.name);
        buf.m_130070_(obj.toString());
    }

    static int fromServer(Player player, FriendlyByteBuf buf) {
        if (player instanceof ServerPlayer) {
            ServerPlayer s = (ServerPlayer)player;
            s.f_8906_.m_9942_((Component)Component.m_237113_((String)"Sent | client -> server | reconfig packet"));
            Refraction.LOGGER.warn("Player {} sent a reconfig load packet\nThis should be impossible!\nPlease report this to the Refraction dev team", (Object)s.m_5446_().getString());
            return 0;
        }
        String name = buf.m_130277_();
        String json = buf.m_130277_();
        JsonReader reader = new JsonReader((Reader)new StringReader(json));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject object = ((JsonObject)gson.fromJson(reader, TypeToken.get(JsonObject.class))).getAsJsonObject();
        ReConfigurer.saveObject(new File("./reconfig/%s.json5".formatted(name)), object);
        ReConfigurer.load("./reconfig/%s".formatted(name), builders.get((Object)Side.COMMON).get(name));
        TwoWayChannel.ReceivedHeader header = configurer.channel().header();
        if (header != null && header.header().m_128461_("option").equals("reconfig")) {
            Refraction.LOGGER.info("Received reconfig file {} from server", (Object)name);
        }
        return 1;
    }

    static {
        RefractionEvents.SERVER_STARTING.register(server -> {
            ReConfigurer.prepareServerConfigs(server);
            ReConfigurer.prepareCommonConfigs(server);
            ReConfigurer.loadAll(Side.SERVER);
        });
        RefractionEvents.SERVER_STOPPING.register(() -> {
            ReConfigurer.saveAll(Side.SERVER);
            ReConfigurer.saveAll(Side.COMMON);
            ReConfigurer.clearSide(Side.SERVER);
        });
    }
}

