/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.reconfig;

import com.google.gson.JsonObject;
import java.util.Objects;
import net.refractionapi.refraction.Refraction;
import net.refractionapi.refraction.feature.reconfig.RCBuilder;

public abstract class ReconfigValue<T> {
    protected T value;
    protected RCBuilder builder;

    public ReconfigValue(T defaultValue) {
        this.value = defaultValue;
    }

    public ReconfigValue() {
        this.value = null;
    }

    public T getValue() {
        return this.value;
    }

    public T get() {
        if (this.builder == null) {
            throw new IllegalStateException("Cannot get value on invalid dist or before config is registered!");
        }
        return this.value;
    }

    public <V extends ReconfigValue<?>> V create(Class<V> configClass) {
        try {
            return (V)((ReconfigValue)configClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            Refraction.LOGGER.error("Failed to create ReconfigValue instance", (Throwable)e);
            return null;
        }
    }

    protected void setUnchecked(Object object) {
        this.value = object;
    }

    public T loadAndGet() {
        if (this.builder == null) {
            throw new IllegalStateException("Cannot get value on invalid dist or before config is registered!");
        }
        this.builder.load();
        return this.value;
    }

    protected void setBuilder(RCBuilder builder) {
        this.builder = builder;
    }

    public void set(T value) {
        if (this.builder == null) {
            throw new IllegalStateException("Cannot set value before config is registered!");
        }
        this.value = value;
        this.builder.save();
    }

    public abstract void serialize(String var1, JsonObject var2);

    public abstract void deserialize(String var1, JsonObject var2);

    public abstract String type();

    public boolean equals(Object obj) {
        ReconfigValue value;
        return obj instanceof ReconfigValue && (value = (ReconfigValue)obj) == this.value;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type());
    }
}

