/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.scheme;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.refractionapi.refraction.client.ClientData;
import net.refractionapi.refraction.feature.channel.TwoWayChannel;
import net.refractionapi.refraction.feature.scheme.RScreen;
import net.refractionapi.refraction.feature.scheme.ScreenScheme;
import net.refractionapi.refraction.feature.scheme.ServerScheme;
import net.refractionapi.refraction.helper.clazz.ClazzUtil;
import org.jetbrains.annotations.Nullable;

public class ScreenRegistry {
    private static final HashMap<Class<? extends ServerScheme>, Class<? extends RScreen>> schemes = new HashMap();
    private RScreen screen = null;
    private ScreenScheme<?> scheme = null;
    private Screen previousScreen = null;
    protected TwoWayChannel screenChannel = null;

    public static void register(Class<? extends ServerScheme> server, Class<? extends RScreen> client) {
        schemes.put(server, client);
    }

    public static <T> T createScreen(ScreenScheme<?> builder, Object[] args) {
        return (T)ClazzUtil.create(schemes.get(builder.schemeClass()), args);
    }

    public void setScreen(@Nullable ScreenScheme<?> scheme, Object ... creatorArgs) {
        Minecraft.m_91087_().m_91152_(null);
        this.scheme = scheme;
        this.screen = null;
        if (scheme == null) {
            return;
        }
        Object screen = scheme.clientScreenCreator.apply(scheme, creatorArgs);
        if (!(screen instanceof Screen) || !(screen instanceof RScreen)) {
            throw new IllegalArgumentException("Screen constructor must return an instance of Screen and implement RScreen!");
        }
        this.screen = (RScreen)screen;
        this.setScreen((Screen)screen);
    }

    private void setScreen(Screen screen) {
        this.previousScreen = Minecraft.m_91087_().f_91080_;
        Minecraft.m_91087_().m_91152_(screen);
    }

    public int handle(ScreenScheme.ScreenMessage screenMessage) {
        if (this.screen != null) {
            this.screen.handle(screenMessage);
        }
        return 1;
    }

    public final int open(ResourceLocation id, UUID uuid, FriendlyByteBuf buf) {
        if (id == null || uuid == null) {
            return 0;
        }
        ScreenScheme<?> scheme = ScreenScheme.builders.get(id);
        if (scheme == null) {
            return 0;
        }
        Object[] args = scheme.deserializer.apply(buf);
        this.initChannel(uuid);
        this.setScreen(scheme, args);
        return 1;
    }

    public final int close(boolean server) {
        if (!server && this.screenChannel != null) {
            this.screenChannel.send("default", buf -> {}, (router, nbt) -> nbt.m_128405_("code", ScreenScheme.Code.CLOSE.ordinal()));
        } else {
            this.screen = null;
            this.scheme = null;
            if (this.screenChannel != null) {
                this.screenChannel.close();
            }
            this.screenChannel = null;
            this.previousScreen = Minecraft.m_91087_().f_91080_;
            this.setScreen(null);
        }
        return 1;
    }

    public final int handle(ScreenScheme.Code code, FriendlyByteBuf buf) {
        if (code.equals((Object)ScreenScheme.Code.DATA)) {
            return this.handle(new ScreenScheme.ScreenMessage(buf));
        }
        if (code.equals((Object)ScreenScheme.Code.OPEN)) {
            return this.open(buf.m_130281_(), buf.m_130259_(), buf);
        }
        this.close(true);
        return 1;
    }

    public void initChannel(UUID id) {
        this.screenChannel = new TwoWayChannel(ClientData.getPlayer().m_9236_(), id).registerListener((plr, buf) -> this.handle(ScreenScheme.Code.values()[this.screenChannel.header().header().m_128451_("code")], buf)).open();
    }
}

