/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.scheme;

import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.refractionapi.refraction.Refraction;
import net.refractionapi.refraction.client.RefractionClient;
import net.refractionapi.refraction.data.PlrExtension;
import net.refractionapi.refraction.data.TData;
import net.refractionapi.refraction.feature.channel.NamedAPI;
import net.refractionapi.refraction.feature.channel.ThreadedAPI;
import net.refractionapi.refraction.feature.channel.TwoWayChannel;
import net.refractionapi.refraction.feature.scheme.ScreenRegistry;
import net.refractionapi.refraction.feature.scheme.ServerScheme;
import net.refractionapi.refraction.helper.clazz.RModRegistrar;
import org.apache.logging.log4j.util.TriConsumer;

public class ScreenScheme<T> {
    protected static final HashMap<ResourceLocation, ScreenScheme<?>> builders = new HashMap();
    protected final ResourceLocation id;
    protected final BiConsumer<Object[], FriendlyByteBuf> serializer;
    protected final Function<FriendlyByteBuf, Object[]> deserializer;
    protected final BiFunction<ScreenScheme<?>, Object[], Object> clientScreenCreator;
    private final Class<? extends ServerScheme> schemeClass;
    protected final TriConsumer<ServerScheme, Code, FriendlyByteBuf> serverHandler;
    protected final Function<ServerPlayer, ServerScheme> serverScreenCreator;
    protected final boolean clientAccessible;
    static ResourceLocation SCREEN_ID = Refraction.id("screen");
    static ThreadedAPI SCREEN_API = NamedAPI.create(SCREEN_ID).configureClient(twc -> twc.registerListener((plr, buf) -> RefractionClient.screenRegistry.handle(Code.OPEN, buf))).configureServer(twc -> twc.registerListener(ScreenScheme::handleOpen)).initCommon();

    private ScreenScheme(ResourceLocation id, BiConsumer<Object[], FriendlyByteBuf> serializer, Function<FriendlyByteBuf, Object[]> deserializer, BiFunction<ScreenScheme<?>, Object[], Object> clientScreenCreator, Class<? extends ServerScheme> schemeClass, TriConsumer<ServerScheme, Code, FriendlyByteBuf> serverHandler, Function<ServerPlayer, ServerScheme> serverScreenCreator, boolean clientAccessible) {
        if (builders.containsKey(id)) {
            throw new RuntimeException("Duplicate screen id %s".formatted(id));
        }
        this.id = id;
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.clientScreenCreator = clientScreenCreator;
        this.schemeClass = schemeClass;
        this.serverHandler = serverHandler;
        this.serverScreenCreator = serverScreenCreator;
        this.clientAccessible = clientAccessible;
        builders.put(id, this);
    }

    protected int handleServer(ServerScheme screen, TwoWayChannel.ReceivedHeader header, FriendlyByteBuf buf) {
        Code code = header.header().m_128441_("code") ? Code.values()[header.header().m_128451_("code")] : Code.DATA;
        this.serverHandler.accept((Object)screen, (Object)code, (Object)buf);
        return 0;
    }

    protected static int handleOpen(Player player, FriendlyByteBuf buf) {
        if (ScreenScheme.data((Player)player).scheme != null || !(player instanceof ServerPlayer)) {
            return 0;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ScreenScheme<?> scheme = builders.get(buf.m_130281_());
        if (scheme == null || !scheme.clientAccessible) {
            Refraction.LOGGER.warn("{} ({}) tried accessing screen which is not #clientAccessible or is invalid - {} ", new Object[]{serverPlayer.m_20149_(), serverPlayer.m_7755_().getString(), scheme == null ? "null" : scheme.id.toString()});
            return 0;
        }
        scheme.open(player, scheme.deserializer.apply(buf));
        return 1;
    }

    protected static PlrExtension data(Player player) {
        return TData.get(player, PlrExtension.class);
    }

    protected Class<? extends ServerScheme> schemeClass() {
        return this.schemeClass;
    }

    public T open(Player player, Object ... args) {
        if (!(player instanceof ServerPlayer)) {
            return null;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerScheme scheme = this.serverScreenCreator.apply(serverPlayer);
        if (scheme == null || !scheme.canOpen()) {
            return null;
        }
        PlrExtension data = ScreenScheme.data(player);
        if (data.scheme != null) {
            data.scheme.close();
        }
        data.scheme = scheme;
        SCREEN_API.channel().send(player, "default", friendlyByteBuf -> {
            friendlyByteBuf.m_130085_(this.id);
            friendlyByteBuf.m_130077_(scheme.channel.id());
            this.serializer.accept(args, friendlyByteBuf);
        }, (rt, ct) -> ct.m_128405_("code", 2));
        return (T)scheme;
    }

    public void open(Object ... args) {
        SCREEN_API.channel().send("default", friendlyByteBuf -> {
            friendlyByteBuf.m_130085_(this.id);
            this.serializer.accept(args, friendlyByteBuf);
        }, (rt, ct) -> ct.m_128405_("code", 2));
    }

    public static <T extends ServerScheme> Builder<T> builder() {
        return new Builder();
    }

    public static enum Code {
        DATA,
        CLOSE,
        OPEN;

    }

    public static class Builder<T extends ServerScheme> {
        private BiConsumer<Object[], FriendlyByteBuf> serializer = (args, buf) -> {};
        private Function<FriendlyByteBuf, Object[]> deserializer = buf -> new Object[0];
        private BiFunction<ScreenScheme<?>, Object[], Object> clientScreenCreator = ScreenRegistry::createScreen;
        private TriConsumer<ServerScheme, Code, FriendlyByteBuf> serverHandler = ServerScheme::handleMsg;
        private Function<ServerPlayer, ServerScheme> serverScreenCreator;
        private Class<? extends ServerScheme> schemeClass;
        private boolean clientAccessible = false;

        private Builder() {
        }

        public Builder<T> serializer(BiConsumer<Object[], FriendlyByteBuf> serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder<T> nbtSerializer(BiConsumer<Object[], CompoundTag> serializer) {
            this.serializer = (objs, buf) -> {
                CompoundTag tag = new CompoundTag();
                serializer.accept((Object[])objs, tag);
                buf.m_130079_(tag);
            };
            return this;
        }

        public Builder<T> deserializer(Function<FriendlyByteBuf, Object[]> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public Builder<T> nbtDeserializer(Function<CompoundTag, Object[]> serializer) {
            this.deserializer = friendlyByteBuf -> (Object[])serializer.apply(friendlyByteBuf.m_130260_());
            return this;
        }

        public Builder<T> clientScreenCreator(BiFunction<ScreenScheme<?>, Object[], Object> clientScreenCreator) {
            this.clientScreenCreator = clientScreenCreator;
            return this;
        }

        public Builder<T> serverHandler(TriConsumer<ServerScheme, Code, FriendlyByteBuf> serverHandler) {
            this.serverHandler = serverHandler;
            return this;
        }

        public Builder<T> serverScreenCreator(Class<? extends ServerScheme> schemeClass, Function<ServerPlayer, ServerScheme> serverScreenCreator) {
            this.serverScreenCreator = serverScreenCreator;
            this.schemeClass = schemeClass;
            return this;
        }

        public Builder<T> clientAccessible() {
            this.clientAccessible = true;
            return this;
        }

        public <S extends ServerScheme> ScreenScheme<S> build(String id) {
            if (this.serverScreenCreator == null) {
                throw new RuntimeException("Server Screen Creator can't be null for id %s!".formatted(id));
            }
            return new ScreenScheme(RModRegistrar.id(id, 2), this.serializer, this.deserializer, this.clientScreenCreator, this.schemeClass, this.serverHandler, this.serverScreenCreator, this.clientAccessible);
        }
    }

    public record ScreenMessage(FriendlyByteBuf buf) {
        public CompoundTag tag() {
            return this.buf.m_130260_();
        }
    }
}

