/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.scheme;

import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.refractionapi.refraction.data.PlrExtension;
import net.refractionapi.refraction.data.TData;
import net.refractionapi.refraction.feature.channel.TwoWayChannel;
import net.refractionapi.refraction.feature.scheme.ScreenScheme;
import org.jetbrains.annotations.ApiStatus;

public abstract class ServerScheme {
    protected final ScreenScheme<?> scheme;
    protected final ServerPlayer player;
    protected final TwoWayChannel channel;

    public <T> ServerScheme(ScreenScheme<T> scheme, ServerPlayer player) {
        this.scheme = scheme;
        this.player = player;
        this.channel = new TwoWayChannel(player.m_9236_());
        this.channel.registerListener((plr, buf) -> scheme.handleServer(this, this.channel.header(), buf)).owner((Entity)player).open();
    }

    public boolean stillValid() {
        return true;
    }

    public boolean canOpen() {
        return this.stillValid();
    }

    public boolean canClose() {
        return true;
    }

    public void onClose() {
    }

    @ApiStatus.Internal
    public void close() {
        this.channel.send("default", buf -> {}, (router, ct) -> ct.m_128405_("code", ScreenScheme.Code.CLOSE.ordinal()));
        this.channel.close();
        this.onClose();
        TData.get((Player)this.player, PlrExtension.class).scheme = null;
    }

    @ApiStatus.Internal
    public void handleMsg(ScreenScheme.Code code, FriendlyByteBuf buf) {
        if (!this.stillValid() || code.equals((Object)ScreenScheme.Code.CLOSE) && this.canClose()) {
            this.close();
            return;
        }
        this.handleMessage(new ScreenScheme.ScreenMessage(buf));
    }

    public abstract void handleMessage(ScreenScheme.ScreenMessage var1);

    public void sendNbt(CompoundTag tag) {
        this.channel.send("default", buf -> buf.m_130079_(tag), (rt, ct) -> ct.m_128405_("code", 0));
    }

    public void sendNbt(Consumer<CompoundTag> tag) {
        CompoundTag compoundTag = new CompoundTag();
        tag.accept(compoundTag);
        this.sendNbt(compoundTag);
    }

    public void sendBuf(Consumer<FriendlyByteBuf> friendlyByteBuf) {
        this.channel.send("default", friendlyByteBuf::accept, (rt, ct) -> ct.m_128405_("code", 0));
    }
}

