/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.screen;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.refractionapi.refraction.client.screen.RDashboard;
import net.refractionapi.refraction.feature.examples.screen.ExampleScreen;
import net.refractionapi.refraction.feature.examples.screen.ExampleScreenRegistry;
import net.refractionapi.refraction.feature.screen.RefractionScreen;
import net.refractionapi.refraction.feature.screen.ScreenBuilder;
import net.refractionapi.refraction.networking.C2S.SendScreenDataC2SPacket;
import net.refractionapi.refraction.networking.RefractionMessages;

@Deprecated
public class ClientScreenHandler {
    private RefractionScreen screen;
    private ScreenBuilder<?> builder;
    private Screen previousScreen = null;
    private Screen closedScreen = null;
    private static final HashMap<ScreenBuilder<?>, Class<? extends Screen>> sceens = new HashMap();

    public void setScreen(@Nullable ScreenBuilder<?> builder, Object ... creatorArgs) {
        Minecraft.m_91087_().m_91152_(null);
        this.builder = builder;
        this.screen = null;
        if (builder == null) {
            return;
        }
        Object screen = builder.createScreen(creatorArgs);
        if (!(screen instanceof Screen) || !(screen instanceof RefractionScreen)) {
            throw new IllegalArgumentException("Screen constructor must return an instance of Screen and implement RefractionScreen");
        }
        this.screen = (RefractionScreen)screen;
        this.setScreen((Screen)screen);
    }

    public void openScreen(ScreenBuilder<?> builder, Object ... args) {
        RefractionMessages.sendToServer(new SendScreenDataC2SPacket(RefractionScreen.Code.OPEN, builder.getNBTId(args)));
    }

    public void onClose(RefractionScreen screen, boolean server) {
        if (!server) {
            RefractionMessages.sendToServer(new SendScreenDataC2SPacket(RefractionScreen.Code.CLOSE));
        } else {
            this.screen = null;
            this.builder = null;
            this.closedScreen = Minecraft.m_91087_().f_91080_;
            this.setScreen(null);
        }
    }

    public void reopenScreen() {
        if (this.closedScreen != null) {
            this.setScreen(this.closedScreen);
            this.closedScreen = null;
        }
    }

    public void handleServerEvent(RefractionScreen.Code code, CompoundTag tag) {
        if (code.equals((Object)RefractionScreen.Code.CLOSE)) {
            this.onClose(null, true);
            return;
        }
        if (code.equals((Object)RefractionScreen.Code.REOPEN)) {
            this.reopenScreen();
            return;
        }
        if (this.screen != null) {
            this.screen.handleServerEvent(code, tag);
        }
    }

    private void setScreen(Screen screen) {
        this.previousScreen = Minecraft.m_91087_().f_91080_;
        Minecraft.m_91087_().m_91152_(screen);
    }

    public Screen getPreviousScreen() {
        return this.previousScreen;
    }

    public void sendData(CompoundTag tag) {
        RefractionMessages.sendToServer(new SendScreenDataC2SPacket(tag));
    }

    public static void registerScreen(ScreenBuilder<?> builder, Class<? extends Screen> screen) {
        sceens.put(builder, screen);
    }

    public static Class<? extends Screen> getScreen(ScreenBuilder<?> builder) {
        return sceens.get(builder);
    }

    public static void init() {
        ClientScreenHandler.registerScreen(ExampleScreenRegistry.EXAMPLE_SCREEN, ExampleScreen.class);
        ClientScreenHandler.registerScreen(ExampleScreenRegistry.DASHBOARD, RDashboard.class);
    }
}

