/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.feature.screen.tab;

import java.awt.Color;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.refractionapi.refraction.feature.screen.RefractionScreen;
import net.refractionapi.refraction.feature.screen.tab.Tab;
import net.refractionapi.refraction.feature.screen.tab.TabNavigator;
import net.refractionapi.refraction.feature.screen.tab.TabWidget;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class TabbedScreen
extends Screen
implements RefractionScreen {
    private final TabNavigator navigator = new TabNavigator();
    private Tab[] tabs = new Tab[0];
    private Tab currentTab;
    private Tab navigatorTab;
    protected int xSize;
    protected int ySize;
    private int borderSize;

    protected TabbedScreen(Component name) {
        super(name);
    }

    protected void m_7856_() {
        this.tabs = new Tab[0];
        this.currentTab = null;
        this.navigatorTab = null;
        this.initSettings();
        Tab navigatorTab = this.createTab((Component)Component.m_237113_((String)"Navigator"), 97, this.ySize);
        navigatorTab.hideName();
        this.navigatorTab = navigatorTab;
        this.initTabs();
        int i = 1;
        while (i < this.tabs.length) {
            Tab tab = this.tabs[i];
            int finalI = i++;
            navigatorTab.addButton(tab.name, 97, 20, button -> this.switchTab(finalI));
        }
        this.changeTab(null, this.navigatorTab);
    }

    protected abstract void initSettings();

    protected void setSize(int xSize, int ySize) {
        this.xSize = xSize;
        this.ySize = ySize;
    }

    protected void setBorderSize(int borderSize) {
        this.borderSize = borderSize;
    }

    protected int[] getPosition() {
        return new int[]{(this.f_96543_ - this.xSize) / 2, (this.f_96544_ - this.ySize) / 2};
    }

    protected int[] getTabPosition(Tab tab) {
        int previousTab = this.getIndex(tab) - 1;
        return new int[]{(this.f_96543_ + (previousTab == -1 ? -this.xSize : -tab.xSize + this.tabs[0].xSize)) / 2, (this.f_96544_ - tab.ySize) / 2};
    }

    protected abstract Color getBackgroundColor();

    protected abstract Color getBorderColor();

    protected abstract void initTabs();

    public Tab createTab(Component name) {
        return this.createTab(name, this.xSize - this.navigatorTab.xSize, this.ySize);
    }

    private Tab createTab(Component name, int xSize, int ySize) {
        Tab tab = new Tab(name, xSize, ySize, this);
        Tab[] newTabs = new Tab[this.tabs.length + 1];
        System.arraycopy(this.tabs, 0, newTabs, 0, this.tabs.length);
        newTabs[this.tabs.length] = tab;
        this.tabs = newTabs;
        return tab;
    }

    public void switchTab(int index) {
        this.currentTab = this.tabs[index];
        this.changeTab(this.currentTab, this.currentTab);
    }

    private void changeTab(Tab oldTab, Tab newTab) {
        if (oldTab != null) {
            for (TabWidget<?> widget : oldTab.getWidgets()) {
                this.m_169411_((GuiEventListener)widget.widget);
            }
        }
        if (newTab != null) {
            for (TabWidget<?> widget : newTab.getWidgets()) {
                this.m_7787_((GuiEventListener)widget.widget);
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        if (this.navigatorTab != null) {
            this.renderTab(this.navigatorTab, guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.currentTab != null) {
            this.renderTab(this.currentTab, guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public void renderTab(Tab tab, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int[] position = this.getTabPosition(tab);
        int padding = 3;
        int minX = position[0];
        int minY = position[1];
        int xSize = tab.xSize;
        int ySize = tab.ySize;
        int maxX = minX + xSize;
        int maxY = minY + ySize;
        this.renderBackground(guiGraphics, minX, minY, maxX, maxY);
        if (!tab.hideName) {
            int textX = maxX - this.borderSize - padding;
            TextColor textColor = tab.name.m_7383_().m_131135_();
            String text = tab.name.getString();
            MutableComponent sequence = Component.m_237113_((String)"%s%s".formatted(text, " ".repeat(text.length() + this.borderSize + this.borderSize / 3))).m_130948_(tab.name.m_7383_());
            guiGraphics.m_280653_(this.f_96541_.f_91062_, (Component)sequence, textX, minY + 2, textColor == null ? 0xFFFFFF : textColor.m_131265_());
        }
        int yOffset = -tab.yScroll;
        guiGraphics.m_280588_(minX, minY, maxX, maxY);
        for (TabWidget<?> tabWidget : tab.getWidgets()) {
            int paddingLeft = tabWidget.getLeftPadding();
            int paddingRight = tabWidget.getRightPadding();
            int paddingBottom = tabWidget.getBottomPadding();
            int paddingTop = tabWidget.getTopPadding();
            tabWidget.widget.m_264152_(minX + paddingLeft - paddingRight, minY + yOffset + paddingTop - paddingBottom);
            tabWidget.widget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            if (tabWidget.nameShown) {
                Object widget = tabWidget.widget;
                guiGraphics.m_280430_(this.f_96547_, widget.m_6035_(), minX + paddingLeft - paddingRight + widget.m_5711_() + 5, minY + yOffset + paddingTop - paddingBottom + widget.m_93694_() / 2 + 2, -2039584);
            }
            yOffset += tabWidget.widget.m_93694_();
        }
        guiGraphics.m_280618_();
    }

    protected Tab getTab(double mouseX, double mouseY) {
        Optional<Tab> ret = Arrays.stream(this.tabs).filter(tab -> {
            int[] tabPos = this.getTabPosition((Tab)tab);
            int minX = tabPos[0];
            int minY = tabPos[1];
            int maxX = minX + tab.xSize;
            int maxY = minY + tab.ySize;
            return (this.currentTab == tab || this.navigatorTab == tab) && mouseX <= (double)maxX && mouseX >= (double)minX && mouseY <= (double)maxY && mouseY >= (double)minY;
        }).findFirst();
        return ret.orElse(null);
    }

    public void renderBackground(GuiGraphics guiGraphics, int minX, int minY, int maxX, int maxY) {
        Color backgroundColor = this.getBackgroundColor();
        Color borderColor = this.getBorderColor();
        guiGraphics.m_280509_(minX - this.borderSize, minY - this.borderSize, maxX + this.borderSize, maxY + this.borderSize, borderColor.getRGB());
        guiGraphics.m_280509_(minX, minY, maxX, maxY, backgroundColor.getRGB());
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        Tab tab = this.getTab(mouseX, mouseY);
        if (tab == null || !tab.isScrollable) {
            return false;
        }
        int maxScroll = tab.getTotalY() - tab.ySize;
        tab.yScroll = Mth.m_14045_((int)(tab.yScroll - (int)delta * 5), (int)0, (int)(maxScroll / 2));
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int release) {
        return this.getTab(mouseX, mouseY) != null && super.m_6375_(mouseX, mouseY, release);
    }

    public Tab currentTab() {
        return this.currentTab;
    }

    public TabNavigator navigator() {
        return this.navigator;
    }

    private int getIndex(Tab tab) {
        for (int i = 0; i < this.tabs.length; ++i) {
            if (this.tabs[i] != tab) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void handleServerEvent(RefractionScreen.Code code, CompoundTag tag) {
    }

    public boolean m_7043_() {
        return false;
    }
}

