/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.gui;

import imgui.ImFont;
import imgui.ImGui;
import imgui.extension.implot.ImPlot;
import imgui.extension.implot.ImPlotContext;
import imgui.gl3.ImGuiImplGl3;
import imgui.glfw.ImGuiImplGlfw;
import imgui.internal.ImGuiContext;
import java.util.Arrays;
import java.util.HashSet;
import net.refractionapi.refraction.events.RefractionEvents;
import net.refractionapi.refraction.feature.channel.NamedAPI;
import net.refractionapi.refraction.gui.IRIMGui;
import net.refractionapi.refraction.gui.RIMNone;
import net.refractionapi.refraction.gui.RIMServer;
import net.refractionapi.refraction.gui.RIMStyle;
import net.refractionapi.refraction.gui.RIMTool;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.NativeResource;

@ApiStatus.Internal
public class RIMGuiInternal
implements NativeResource,
IRIMGui {
    private static final RIMNone none = new RIMNone();
    public static RIMGuiInternal gui;
    private final ImGuiImplGlfw imGuiGlfw = new ImGuiImplGlfw();
    private final ImGuiImplGl3 imGuiGl3 = new ImGuiImplGl3();
    private ImGuiContext context;
    private ImPlotContext contextPlot;
    private HashSet<RIMTool> tools;
    private boolean active;
    public final NamedAPI channel = NamedAPI.create(RIMServer.CHANNEL_NAME).initOnOpen();

    public RIMGuiInternal(long ptr, RIMTool ... tools) {
        gui = this;
        this.tools = new HashSet();
        Arrays.asList(tools).forEach(this::addWidget);
        this.context = new ImGuiContext(ImGui.createContext().ptr);
        this.contextPlot = new ImPlotContext(ImPlot.createContext().ptr);
        this.imGuiGlfw.init(ptr, true);
        this.imGuiGl3.init("#version 410 core");
        RIMStyle.init();
        ImGui.setCurrentContext(this.context);
        ImPlot.setCurrentContext(this.contextPlot);
    }

    @Override
    public void beginFrame() {
        this.imGuiGlfw.newFrame();
        this.imGuiGl3.newFrame();
        ImGui.newFrame();
    }

    @Override
    public void endFrame() {
        if (this.active) {
            this.render();
        }
        ImGui.render();
        this.imGuiGl3.renderDrawData(ImGui.getDrawData());
        if (ImGui.getIO().hasConfigFlags(1024)) {
            long backupWindowPtr = GLFW.glfwGetCurrentContext();
            ImGui.updatePlatformWindows();
            ImGui.renderPlatformWindowsDefault();
            GLFW.glfwMakeContextCurrent((long)backupWindowPtr);
        }
    }

    public void render() {
        this.renderBar();
        this.tools.stream().filter(tool -> tool.open.get()).forEach(RIMTool::render);
    }

    public void renderBar() {
        if (!ImGui.beginMainMenuBar()) {
            return;
        }
        ImFont font = ImGui.getFont();
        float width = font.calcTextSizeAX(ImGui.getFontSize(), Float.MAX_VALUE, 0.0f, " Refraction ");
        float height = ImGui.getTextLineHeightWithSpacing() + 8.0f;
        ImGui.getWindowDrawList().addRectFilled(0.0f, 0.0f, width, height, ImGui.getColorU32(8));
        ImGui.text("Refraction ");
        for (RIMTool widget : this.tools) {
            if (!ImGui.beginMenu(widget.group())) continue;
            if (ImGui.menuItem(widget.name())) {
                widget.toggle();
            }
            ImGui.endMenu();
        }
        ImGui.endMainMenuBar();
    }

    public void tickAll() {
        this.tools.forEach(RIMTool::tick);
    }

    @Override
    public <T extends RIMTool> T byNameAndGroup(String name, String group) {
        return (T)((RIMTool)this.tools.stream().filter(tool -> tool.name().equals(name) && tool.group().equals(group)).findFirst().orElse(null));
    }

    @Override
    public void toggle() {
        this.active = !this.active;
    }

    @Override
    public boolean onMouseButton(long window, int button, int action, int mods) {
        return ImGui.getIO().getWantCaptureMouse();
    }

    @Override
    public boolean onScroll(double xoffset, double yoffset) {
        return ImGui.getIO().getWantCaptureMouse();
    }

    @Override
    public void onGrabMouse() {
        ImGui.setWindowFocus(null);
    }

    @Override
    public boolean onKey(long window, int key, int scancode, int action, int mods) {
        return ImGui.getIO().getWantCaptureKeyboard();
    }

    @Override
    public boolean onChar(long window, int codepoint, int mod) {
        return ImGui.getIO().getWantTextInput();
    }

    public void free() {
        this.imGuiGl3.destroyDeviceObjects();
        this.imGuiGlfw.shutdown();
        ImGui.destroyContext();
        ImPlot.destroyContext(this.contextPlot);
    }

    public void addWidget(RIMTool widget) {
        this.tools.add(widget);
        widget.init();
    }

    public static IRIMGui get() {
        return gui == null ? none : gui;
    }

    static {
        RefractionEvents.CLIENT_TICK.register(post -> {
            if (gui != null && post) {
                gui.tickAll();
            }
        });
    }
}

