/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.gui;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.refractionapi.refraction.Refraction;
import net.refractionapi.refraction.config.RServerConfig;
import net.refractionapi.refraction.events.RefractionEvent;
import net.refractionapi.refraction.events.RefractionEventCaller;
import net.refractionapi.refraction.events.RefractionEvents;
import net.refractionapi.refraction.feature.channel.NamedAPI;
import net.refractionapi.refraction.feature.channel.TwoWayChannel;
import net.refractionapi.refraction.gui.cli.CLIComms;
import org.apache.commons.lang3.function.TriFunction;

public class RIMServer {
    public static final ResourceLocation CHANNEL_NAME = Refraction.id("rim_server");
    public static final RefractionEvent<RegisterChannels> REGISTER_CHANNEL = new RefractionEventCaller<RegisterChannels>(RegisterChannels.class, listeners -> server -> {
        for (RegisterChannels listener : listeners) {
            listener.register(server);
        }
    });
    private static RIMServer instance = null;
    private final NamedAPI channel;
    private final MinecraftServer server;
    long last = 0L;
    long ticks = 0L;

    private RIMServer(MinecraftServer server) {
        this.server = server;
        new CLIComms(server);
        this.channel = NamedAPI.create(CHANNEL_NAME).configure(channel -> {
            channel.valid((TriFunction<Player, FriendlyByteBuf, String, Boolean>)((TriFunction)(plr, buf, router) -> RServerConfig.isPermitted(plr)));
            channel.canSendTo(RServerConfig::isPermitted);
            channel.registerListener("auth", this::isValid);
        }).open((Level)server.m_129783_());
        REGISTER_CHANNEL.invoker().register(this.channel.channel());
        RefractionEvents.SERVER_TICK.register(post -> {
            if (!post) {
                return;
            }
            this.serverHealth();
        });
    }

    public int isValid(Player player, FriendlyByteBuf buf) {
        this.channel.channel().respond(this.channel.channel().header(), data -> {});
        return 1;
    }

    public void serverHealth() {
        long time = System.currentTimeMillis();
        ++this.ticks;
        if (time - this.last < 1000L) {
            return;
        }
        this.channel.channel().send("health", buf -> {
            double tps = this.ticks;
            this.last = time;
            this.ticks = 0L;
            int players = this.server.m_7416_();
            int entities = Arrays.stream((ServerLevel[])Iterators.toArray(this.server.m_129785_().iterator(), ServerLevel.class)).mapToInt(level -> Iterators.size(level.m_8583_().iterator())).sum();
            int chunks = Arrays.stream((ServerLevel[])Iterators.toArray(this.server.m_129785_().iterator(), ServerLevel.class)).mapToInt(level -> level.m_7726_().m_8482_()).sum();
            buf.writeDouble(tps);
            buf.writeInt(players);
            buf.writeInt(entities);
            buf.writeInt(chunks);
        });
    }

    public static void init() {
        RefractionEvents.SERVER_STARTING.register(server -> {
            instance = new RIMServer(server);
        });
    }

    public static Optional<RIMServer> get() {
        return Optional.ofNullable(instance);
    }

    @FunctionalInterface
    public static interface RegisterChannels {
        public void register(TwoWayChannel var1);
    }
}

