/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.gui.cli;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import joptsimple.internal.Strings;
import net.refractionapi.refraction.events.RefractionClientEvents;
import net.refractionapi.refraction.gui.cli.CLICmd;
import net.refractionapi.refraction.gui.cli.CLIServerCommand;
import net.refractionapi.refraction.gui.cli.ClearCmd;
import net.refractionapi.refraction.gui.cli.HelpCmd;
import net.refractionapi.refraction.gui.cli.HijackCmd;
import net.refractionapi.refraction.gui.cli.LSCmd;

public class CLI {
    private final HashMap<String, CLICmd> cmds = new HashMap();
    private final CopyOnWriteArrayList<String> history = new CopyOnWriteArrayList();

    public CLI() {
        this.compileCmds();
    }

    public void runCommand(String[] args) {
        if (args.length == 0 || args[0].isEmpty()) {
            this.print("Invalid syntax");
            return;
        }
        String command = args[0];
        this.history.add("$>%s".formatted(Strings.join((String[])args, (String)" ")));
        if (!this.cmds.containsKey(command)) {
            this.print("Command '%s' does not exist!\nRun 'help' or 'help -d' for info!".formatted(command));
            return;
        }
        String[] cmdArgs = (String[])Arrays.stream(args).skip(1L).filter(arg -> !arg.isEmpty()).map(String::strip).toArray(String[]::new);
        this.cmds.get(command).exec(cmdArgs);
    }

    public void print(String s) {
        this.history.add(s);
    }

    public String[] getCmds() {
        return (String[])this.cmds.keySet().toArray(String[]::new);
    }

    public CLICmd getCmd(String cmd) {
        return this.cmds.get(cmd);
    }

    public String[] getDescCmds() {
        return (String[])this.cmds.keySet().stream().map(s -> "%s - %s".formatted(s, this.cmds.get(s).description())).toArray(String[]::new);
    }

    public List<String> history() {
        return this.history;
    }

    private void compileCmds() {
        this.add(new HelpCmd(this));
        this.add(new ClearCmd(this));
        this.add(new HijackCmd(this));
        this.add(new LSCmd(this));
        this.add(new CLIServerCommand(this));
        RefractionClientEvents.CLI_REGISTER.invoker().register(this);
    }

    public void add(CLICmd cliCmd) {
        this.cmds.compute(cliCmd.command(), (k, v) -> {
            if (v == null) {
                return cliCmd;
            }
            if (v.priority() >= cliCmd.priority()) {
                v.combine(cliCmd);
            } else {
                v = cliCmd.combine((CLICmd)v);
            }
            return v;
        });
        this.cmds.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> this.cmds.put((String)e.getKey(), (CLICmd)e.getValue()));
    }
}

