/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.gui.cli;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.refractionapi.refraction.feature.channel.NamedAPI;
import net.refractionapi.refraction.feature.channel.TwoWayChannel;
import net.refractionapi.refraction.feature.channel.TwoWayIntermediary;
import net.refractionapi.refraction.gui.cli.CLI;
import net.refractionapi.refraction.gui.cli.CLICmd;
import net.refractionapi.refraction.util.Pair;

public class HijackCmd
extends CLICmd {
    private int id = -1;
    private String router = "";
    private FriendlyByteBuf buf;
    private CompoundTag header;

    public HijackCmd(CLI cli) {
        super(cli);
    }

    @Override
    public String command() {
        return "hj";
    }

    @Override
    public String description() {
        return "Hijacks any channel connection, and sends specified packets - useful for pen-testing.";
    }

    @Override
    public void mapArgs() {
        this.mapArg("-i", "Writes int to buf.", this::writeInt);
        this.mapArg("-s", "Writes string to buf.", this::writeString);
        this.mapArg("-h", "Specifies header write. [ID] -[arg] [ARG]", this::empty);
    }

    public boolean writeInt(String[] args, int pos) {
        if (!this.hasTrailing(args, pos)) {
            this.print("Invalid usage of -i [INT]");
            return false;
        }
        int parsedInt = this.parseInt(args[pos + 1]);
        if (this.header != null) {
            this.header.m_128405_(args[pos - 1], parsedInt);
            return true;
        }
        this.buf.writeInt(parsedInt);
        return true;
    }

    public boolean writeString(String[] args, int pos) {
        if (!this.hasTrailing(args, pos)) {
            this.print("Invalid usage of -s [STRING]");
            return false;
        }
        if (this.header != null) {
            this.header.m_128359_(args[pos - 1], args[pos + 1]);
            return true;
        }
        this.buf.m_130070_(args[pos + 1]);
        return true;
    }

    @Override
    public void exec(String[] args) {
        if (args.length < 2) {
            this.print("Invalid command usage!\nhj [ID] [ROUTER] [ARGS]");
            return;
        }
        this.id = this.parseInt(args[0]);
        if (this.id <= -1) {
            return;
        }
        this.router = args[1];
        List<Pair<UUID, Optional<TwoWayChannel>>> channels = TwoWayIntermediary.instance(false).channels();
        if (channels.size() - 1 < this.id) {
            this.print("Invalid id %s, out of range! [0 -> %s]".formatted(this.id, channels.size() - 1));
            return;
        }
        this.header = null;
        this.buf = null;
        channels.get(this.id).getSecond().ifPresent(c -> c.send(this.router, buf -> {
            this.buf = buf;
            this.runArgs(this.subStringTillArgs(args, "-h"));
            ResourceLocation namedAPI = NamedAPI.getChannel(c.id()).orElse(null);
            this.print("Sent packet to %s [router: %s]%s".formatted(c.id(), this.router, namedAPI == null ? "" : " [api: %s]".formatted(namedAPI.toString())));
        }, (id, nbt) -> {
            this.header = nbt;
            this.runArgs(this.subStringArgs(args, "-h"));
        }));
    }
}

