/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.helper.data;

import java.util.HashMap;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.apache.logging.log4j.util.TriConsumer;

public class DoubleMap<K, X, Y> {
    private final HashMap<K, Entry> map = new HashMap();

    public void put(K key, X x, Y y) {
        this.map.put(key, new Entry(x, y));
    }

    private Entry getHandler(K key) {
        return this.map.get(key);
    }

    public X getX(K key) {
        return this.getHandler(key).getX();
    }

    public Y getY(K key) {
        return this.getHandler(key).getY();
    }

    public void setX(K key, X x) {
        this.getHandler(key).setX(x);
    }

    public void setY(K key, Y y) {
        this.getHandler(key).setY(y);
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    public void forEach(TriConsumer<K, X, Y> consumer) {
        this.map.forEach((? super K key, ? super V entry) -> consumer.accept(key, entry.getX(), entry.getY()));
    }

    public void removeIf(BiPredicate<X, Y> predicate) {
        this.map.entrySet().removeIf((? super E entry) -> predicate.test(((Entry)entry.getValue()).getX(), ((Entry)entry.getValue()).getY()));
    }

    public Stream<K> keyStream() {
        return this.map.keySet().stream();
    }

    public Stream<Entry> entryStream() {
        return this.map.values().stream();
    }

    public class Entry {
        private X x;
        private Y y;

        public Entry(X x, Y y) {
            this.x = x;
            this.y = y;
        }

        public X getX() {
            return this.x;
        }

        public Y getY() {
            return this.y;
        }

        public void setX(X x) {
            this.x = x;
        }

        public void setY(Y y) {
            this.y = y;
        }
    }
}

