/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.helper.entity;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.refractionapi.refraction.events.RefractionEvents;
import net.refractionapi.refraction.mixininterfaces.ILivingEntity;
import net.refractionapi.refraction.networking.RefractionMessages;
import net.refractionapi.refraction.networking.S2C.EnablePlayerMovementS2CPacket;
import net.refractionapi.refraction.util.Mutable;

public class FrozenManager {
    private static final ConcurrentHashMap<LivingEntity, FrozenData> frozenData = new ConcurrentHashMap();

    public static void setFrozenTicks(LivingEntity entity, Vec3 teleport, int ticks) {
        FrozenManager.computeMap(entity, (k, v) -> {
            if (v == null) {
                return new FrozenData(teleport, new Mutable<Integer>(ticks));
            }
            v.ticks.value = ticks;
            if ((Integer)v.ticks.value <= 0 && ticks != -1) {
                FrozenManager.unfreeze(entity);
            }
            return v;
        });
    }

    public static void setFrozenTicks(LivingEntity entity, int ticks) {
        FrozenManager.setFrozenTicks(entity, null, ticks);
    }

    public static void setFrozen(LivingEntity entity, Vec3 teleport) {
        FrozenManager.setFrozenTicks(entity, teleport, -1);
    }

    public static void setFrozen(LivingEntity entity) {
        FrozenManager.setFrozenTicks(entity, null, -1);
    }

    public static void addFrozenTicks(LivingEntity entity, Vec3 teleport, int ticks) {
        FrozenManager.computeMap(entity, (k, v) -> {
            if (v == null) {
                return new FrozenData(null, new Mutable<Integer>(ticks));
            }
            Mutable<Integer> mutable = v.ticks;
            mutable.value = (Integer)mutable.value + ticks;
            if ((Integer)v.ticks.value <= 0) {
                FrozenManager.unfreeze(entity);
            }
            return v;
        });
    }

    public static void unfreeze(LivingEntity entity) {
        entity.f_19864_ = true;
        frozenData.remove(entity);
        FrozenManager.enableMovement(entity, true);
    }

    public static void enableMovement(LivingEntity entity, boolean canMove) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            RefractionMessages.sendToPlayer(new EnablePlayerMovementS2CPacket(canMove), player);
        } else if (entity instanceof ILivingEntity) {
            ((ILivingEntity)entity).refractionAPI_MC$enableMovement(canMove);
        }
    }

    private static void computeMap(LivingEntity entity, BiFunction<LivingEntity, FrozenData, FrozenData> remappingFunction) {
        frozenData.compute(entity, remappingFunction);
        FrozenManager.enableMovement(entity, frozenData.get(entity) == null || (Integer)FrozenManager.frozenData.get((Object)entity).ticks.value <= 0);
    }

    public static void init() {
        RefractionEvents.SERVER_TICK.register(post -> frozenData.forEach((entity, data) -> {
            if ((Integer)data.ticks.value > 0 || (Integer)data.ticks.value == -1) {
                if (data.teleportPos != null) {
                    entity.m_6021_(data.teleportPos.m_7096_(), data.teleportPos.m_7098_(), data.teleportPos.m_7094_());
                }
                data.ticks.value = (Integer)data.ticks.value == -1 ? -1 : Math.max(0, (Integer)data.ticks.value - 1);
                if ((Integer)data.ticks.value <= 0 && (Integer)data.ticks.value != -1) {
                    FrozenManager.unfreeze(entity);
                }
            }
        }));
    }

    private record FrozenData(Vec3 teleportPos, Mutable<Integer> ticks) {
    }
}

