/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.helper.math;

import java.util.HashMap;
import net.minecraft.util.Mth;
import net.refractionapi.refraction.helper.math.ColorUtils;

public class ColorInterpolator {
    private HashMap<Float, Section> sections = new HashMap();
    private int previousColor = -1;

    public ColorInterpolator addPoint(int fromColor, int toColor, float ratio, float atPosition) {
        if (atPosition < 0.0f || atPosition > 1.0f) {
            throw new IllegalArgumentException("Can't have delta be smaller than 0 or bigger than 1!");
        }
        this.previousColor = toColor;
        this.sections.put(Float.valueOf(atPosition), new Section(fromColor, toColor, ratio));
        this.sections = this.sections.entrySet().stream().sorted((o1, o2) -> Float.compare(((Float)o1.getKey()).floatValue(), ((Float)o2.getKey()).floatValue())).collect(HashMap::new, (m, e) -> m.put((Float)e.getKey(), (Section)e.getValue()), HashMap::putAll);
        return this;
    }

    public ColorInterpolator addPoint(int color, float ratio, float atPosition) {
        return this.addPoint(this.previousColor, color, ratio, atPosition);
    }

    public int getColor(float delta) {
        delta = Mth.m_14036_((float)delta, (float)0.0f, (float)1.0f);
        int index = 0;
        for (Float key : this.sections.keySet()) {
            if (!(delta > key.floatValue()) && ++index != this.sections.size()) continue;
            Section section = this.sections.get(key);
            return ColorUtils.interpolateColor(section.fromColor, section.toColor, (delta - key.floatValue()) / section.ratio);
        }
        return -1;
    }

    public int getOrDefault(float delta, int defaultColor) {
        int color = this.getColor(delta);
        return color == -1 ? defaultColor : color;
    }

    private record Section(int fromColor, int toColor, float ratio) {
    }
}

