/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.helper.math;

public class ColorUtils {
    public static int getCurrentColorRendering(int colorStart, int colorEnd, long currentTick) {
        float position = (float)currentTick % 100.0f / 100.0f;
        if (position <= 0.5f) {
            return ColorUtils.interpolateColor(colorStart, colorEnd, position * 2.0f);
        }
        return ColorUtils.interpolateColor(colorEnd, colorStart, (position - 0.5f) * 2.0f);
    }

    public static int interpolateColor(int color1, int color2, float ratio) {
        int r = ColorUtils.interpolateComponent(color1 >> 16 & 0xFF, color2 >> 16 & 0xFF, ratio);
        int g = ColorUtils.interpolateComponent(color1 >> 8 & 0xFF, color2 >> 8 & 0xFF, ratio);
        int b = ColorUtils.interpolateComponent(color1 & 0xFF, color2 & 0xFF, ratio);
        return r << 16 | g << 8 | b;
    }

    private static int interpolateComponent(int c1, int c2, float ratio) {
        return Math.round((float)c1 + (float)(c2 - c1) * ratio);
    }
}

