/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.helper.math;

import net.minecraft.util.Mth;
import net.refractionapi.refraction.helper.math.EasingFunction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EasingFunctions implements EasingFunction
{
    LINEAR{

        @Override
        public float getEasing(float x) {
            return x;
        }
    }
    ,
    EASE_IN_SINE{

        @Override
        public float getEasing(float x) {
            return 1.0f - Mth.m_14089_((float)(x * (float)Math.PI / 2.0f));
        }
    }
    ,
    EASE_OUT_SINE{

        @Override
        public float getEasing(float x) {
            return (float)Math.sin((double)x * Math.PI / 2.0);
        }
    }
    ,
    EASE_IN_OUT_SINE{

        @Override
        public float getEasing(float x) {
            return (float)(-(Math.cos(Math.PI * (double)x) - 1.0)) / 2.0f;
        }
    }
    ,
    EASE_IN_CUBIC{

        @Override
        public float getEasing(float x) {
            return x * x * x;
        }
    }
    ,
    EASE_OUT_CUBIC{

        @Override
        public float getEasing(float x) {
            return (float)(1.0 - Math.pow(1.0f - x, 3.0));
        }
    }
    ,
    EASE_IN_OUT_CUBIC{

        @Override
        public float getEasing(float x) {
            return (double)x < 0.5 ? 4.0f * x * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0);
        }
    }
    ,
    EASE_IN_QUINT{

        @Override
        public float getEasing(float x) {
            return x * x * x * x * x;
        }
    }
    ,
    EASE_OUT_QUINT{

        @Override
        public float getEasing(float x) {
            return (float)(1.0 - Math.pow(1.0f - x, 5.0));
        }
    }
    ,
    EASE_IN_OUT_QUINT{

        @Override
        public float getEasing(float x) {
            return (double)x < 0.5 ? 16.0f * x * x * x * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 5.0) / 2.0);
        }
    }
    ,
    EASE_IN_CIRC{

        @Override
        public float getEasing(float x) {
            return 1.0f - (float)Math.sqrt(1.0 - Math.pow(x, 2.0));
        }
    }
    ,
    EASE_OUT_CIRC{

        @Override
        public float getEasing(float x) {
            return (float)Math.sqrt(1.0 - Math.pow(x - 1.0f, 2.0));
        }
    }
    ,
    EASE_IN_OUT_CIRC{

        @Override
        public float getEasing(float x) {
            return (double)x < 0.5 ? (float)(1.0 - Math.sqrt(1.0 - Math.pow(2.0f * x, 2.0))) / 2.0f : (float)(Math.sqrt(1.0 - Math.pow(-2.0f * x + 2.0f, 2.0)) + 1.0) / 2.0f;
        }
    }
    ,
    EASE_IN_ELASTIC{

        @Override
        public float getEasing(float x) {
            double c4 = 2.0943951023931953;
            return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : -Math.pow(2.0, 10.0f * x - 10.0f) * Math.sin(((double)(x * 10.0f) - 10.75) * c4));
        }
    }
    ,
    EASE_OUT_ELASTIC{

        @Override
        public float getEasing(float x) {
            double c4 = 2.0943951023931953;
            return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : Math.pow(2.0, -10.0f * x) * Math.sin(((double)(x * 10.0f) - 0.75) * c4) + 1.0);
        }
    }
    ,
    EASE_IN_OUT_ELASTIC{

        @Override
        public float getEasing(float x) {
            double c5 = 1.3962634015954636;
            return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : ((double)x < 0.5 ? -(Math.pow(2.0, 20.0f * x - 10.0f) * Math.sin(((double)(20.0f * x) - 11.125) * c5)) / 2.0 : Math.pow(2.0, -20.0f * x + 10.0f) * Math.sin(((double)(20.0f * x) - 11.125) * c5) / 2.0 + 1.0));
        }
    }
    ,
    EASE_IN_QUAD{

        @Override
        public float getEasing(float x) {
            return x * x;
        }
    }
    ,
    EASE_OUT_QUAD{

        @Override
        public float getEasing(float x) {
            return (float)(1.0 - Math.pow(1.0f - x, 2.0));
        }
    }
    ,
    EASE_IN_OUT_QUAD{

        @Override
        public float getEasing(float x) {
            return (double)x < 0.5 ? 2.0f * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 2.0) / 2.0);
        }
    }
    ,
    EASE_IN_QUART{

        @Override
        public float getEasing(float x) {
            return x * x * x * x;
        }
    }
    ,
    EASE_OUT_QUART{

        @Override
        public float getEasing(float x) {
            return (float)(1.0 - Math.pow(1.0f - x, 4.0));
        }
    }
    ,
    EASE_IN_OUT_QUART{

        @Override
        public float getEasing(float x) {
            return (double)x < 0.5 ? 8.0f * x * x * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 4.0) / 2.0);
        }
    }
    ,
    EASE_IN_EXPO{

        @Override
        public float getEasing(float x) {
            return x == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * x - 10.0f);
        }
    }
    ,
    EASE_OUT_EXPO{

        @Override
        public float getEasing(float x) {
            return x == 1.0f ? 1.0f : (float)(1.0 - Math.pow(2.0, -10.0f * x));
        }
    }
    ,
    EASE_IN_OUT_EXPO{

        @Override
        public float getEasing(float x) {
            return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : ((double)x < 0.5 ? Math.pow(2.0, 20.0f * x - 10.0f) / 2.0 : (2.0 - Math.pow(2.0, -20.0f * x + 10.0f)) / 2.0));
        }
    }
    ,
    EASE_IN_BACK{

        @Override
        public float getEasing(float x) {
            double c1 = 1.70158;
            double c3 = c1 + 1.0;
            return (float)(c3 * (double)x * (double)x * (double)x - c1 * (double)x * (double)x);
        }
    }
    ,
    EASE_OUT_BACK{

        @Override
        public float getEasing(float x) {
            double c1 = 1.70158;
            double c3 = c1 + 1.0;
            return (float)(1.0 + c3 * Math.pow(x - 1.0f, 3.0) + c1 * Math.pow(x - 1.0f, 2.0));
        }
    }
    ,
    EASE_IN_OUT_BACK{

        @Override
        public float getEasing(float x) {
            double c1 = 1.70158;
            double c2 = c1 * 1.525;
            return (float)((double)x < 0.5 ? Math.pow(2.0f * x, 2.0) * ((c2 + 1.0) * 2.0 * (double)x - c2) / 2.0 : (Math.pow(2.0f * x - 2.0f, 2.0) * ((c2 + 1.0) * (double)(x * 2.0f - 2.0f) + c2) + 2.0) / 2.0);
        }
    };

}

