/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.helper.misc;

import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.refractionapi.refraction.util.FileUtil;
import net.refractionapi.refraction.util.Pair;

public class TagIO {
    private final String directoryPath;

    public TagIO(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public void createIfNotPresent(String fileName) {
        FileUtil.createIfNotPresent("%s/%s.nbt".formatted(this.directoryPath, fileName));
    }

    public void save(String fileName, CompoundTag tag) {
        FileUtil.saveCompound("%s/%s.nbt".formatted(this.directoryPath, fileName), tag);
    }

    public CompoundTag load(String fileName) {
        return FileUtil.loadCompound("%s/%s.nbt".formatted(this.directoryPath, fileName));
    }

    public void delete(String fileName) {
        FileUtil.deleteFile("%s/%s.nbt".formatted(this.directoryPath, fileName));
    }

    public boolean exists(String fileName) {
        return FileUtil.exists("%s/%s.nbt".formatted(this.directoryPath, fileName));
    }

    public Pair<String, CompoundTag>[] list() {
        return (Pair[])Arrays.stream(FileUtil.getFiles(this.directoryPath)).map(name -> new Pair<String, CompoundTag>((String)name, this.load((String)name))).toArray(Pair[]::new);
    }
}

