/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.helper.randomizer;

import java.util.HashMap;

public class WeightedRandom<T> {
    public final HashMap<T, Float> weightedRandomList = new HashMap();

    public WeightedRandom<T> add(T t, float weight) {
        this.weightedRandomList.put(t, Float.valueOf(weight));
        return this;
    }

    public T get() {
        float totalWeight = 0.0f;
        for (float weight : this.weightedRandomList.values()) {
            totalWeight += weight;
        }
        float random = (float)Math.random() * totalWeight;
        for (T t : this.weightedRandomList.keySet()) {
            if (!((random -= this.weightedRandomList.get(t).floatValue()) <= 0.0f)) continue;
            return t;
        }
        return null;
    }

    public HashMap<T, Float> getPercentages() {
        float totalWeight = 0.0f;
        for (float weight : this.weightedRandomList.values()) {
            totalWeight += weight;
        }
        HashMap<T, Float> percentages = new HashMap<T, Float>();
        for (T t : this.weightedRandomList.keySet()) {
            percentages.put(t, Float.valueOf(this.weightedRandomList.get(t).floatValue() / totalWeight));
        }
        return percentages;
    }

    @SafeVarargs
    public static <T> WeightedRandom<T> of(T ... items) {
        WeightedRandom<T> weightedRandom = new WeightedRandom<T>();
        for (T t1 : items) {
            weightedRandom.add(t1, 1.0f);
        }
        return weightedRandom;
    }

    public HashMap<T, Float> getWeightedRandomList() {
        return this.weightedRandomList;
    }
}

