/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.helper.runnable;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import net.minecraft.world.level.LevelAccessor;
import net.refractionapi.refraction.events.RefractionEvents;

public class TickableProccesor {
    private static final ConcurrentHashMap<TickableProccesor, LevelAccessor> RUNNABLES = new ConcurrentHashMap();
    private boolean running = false;
    private BiConsumer<LevelAccessor, Boolean> process = (level, post) -> {};
    private Runnable onStop = () -> {};
    private BooleanSupplier supplier = () -> true;

    public TickableProccesor process(BiConsumer<LevelAccessor, Boolean> process) {
        this.process = process;
        return this;
    }

    public TickableProccesor shouldRun(BooleanSupplier supplier) {
        this.supplier = supplier;
        return this;
    }

    public TickableProccesor onStop(Runnable runnable) {
        this.onStop = runnable;
        return this;
    }

    public void start(LevelAccessor level) {
        this.running = true;
        RUNNABLES.put(this, level);
    }

    public void stop() {
        this.running = false;
        this.onStop.run();
    }

    public static void init() {
        RefractionEvents.LEVEL_TICK.register((level, post) -> {
            RUNNABLES.keySet().removeIf(processor -> {
                boolean stop;
                boolean bl = stop = !processor.running || !processor.supplier.getAsBoolean();
                if (stop) {
                    processor.stop();
                }
                return stop;
            });
            RUNNABLES.entrySet().stream().filter(entry -> ((LevelAccessor)entry.getValue()).equals(level)).forEach(processor -> ((TickableProccesor)processor.getKey()).process.accept(level, post));
        });
    }
}

