/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.helper.vec3;

import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.refractionapi.refraction.helper.vec3.Vec3Helper;

public class RAAB
extends AABB {
    public final Vec3[][] positions;

    private RAAB(Vec3[][] positions, double x1, double y1, double z1, double x2, double y2, double z2) {
        super(x1, y1, z1, x2, y2, z2);
        this.positions = positions;
    }

    public static RAAB create(Vec3 bottomLeft1, Vec3 bottomRight1, Vec3 topRight1, Vec3 topLeft1, Vec3 bottomLeft2, Vec3 bottomRight2, Vec3 topRight2, Vec3 topLeft2) {
        return RAAB.create(bottomLeft1.f_82479_, bottomLeft1.f_82480_, bottomLeft1.f_82481_, bottomRight1.f_82479_, bottomRight1.f_82480_, bottomRight1.f_82481_, topRight1.f_82479_, topRight1.f_82480_, topRight1.f_82481_, topLeft1.f_82479_, topLeft1.f_82480_, topLeft1.f_82481_, bottomLeft2.f_82479_, bottomLeft2.f_82480_, bottomLeft2.f_82481_, bottomRight2.f_82479_, bottomRight2.f_82480_, bottomRight2.f_82481_, topRight2.f_82479_, topRight2.f_82480_, topRight2.f_82481_, topLeft2.f_82479_, topLeft2.f_82480_, topLeft2.f_82481_);
    }

    public static RAAB create(BlockPos bottomLeft, BlockPos bottomRight, BlockPos topRight, BlockPos topLeft) {
        return RAAB.create(bottomLeft.m_123341_(), bottomLeft.m_123342_(), bottomLeft.m_123343_(), bottomRight.m_123341_(), bottomRight.m_123342_(), bottomRight.m_123343_(), topRight.m_123341_(), topRight.m_123342_(), topRight.m_123343_(), topLeft.m_123341_(), topLeft.m_123342_(), topLeft.m_123343_());
    }

    public static RAAB create(BlockPos bottomLeft, BlockPos topRight) {
        BlockPos[] corners = Vec3Helper.createRectangle(bottomLeft, topRight);
        return RAAB.create(bottomLeft, corners[0], topRight, corners[1]);
    }

    public static RAAB create(Vec3 bottomLeft, Vec3 topRight) {
        Vec3[] corners = Vec3Helper.createRectangle(bottomLeft, topRight);
        return RAAB.create(bottomLeft, corners[0], topRight, corners[1]);
    }

    public static RAAB create(Vec3 bottomLeft, Vec3 bottomRight, Vec3 topRight, Vec3 topLeft) {
        return RAAB.create(bottomLeft.f_82479_, bottomLeft.f_82480_, bottomLeft.f_82481_, bottomRight.f_82479_, bottomRight.f_82480_, bottomRight.f_82481_, topRight.f_82479_, topRight.f_82480_, topRight.f_82481_, topLeft.f_82479_, topLeft.f_82480_, topLeft.f_82481_);
    }

    public static RAAB create(double ... coords) {
        if (coords.length != 12 && coords.length != 24) {
            throw new InstantiationError("Coord length is not supported (12 or 24 only)");
        }
        double[] finalCoods = new double[24];
        System.arraycopy(coords, 0, finalCoods, 0, coords.length);
        if (coords.length == 12) {
            System.arraycopy(coords, 0, finalCoods, 12, coords.length);
        }
        Vec3[][] positions = new Vec3[2][4];
        for (int i = 0; i < finalCoods.length; i += 3) {
            positions[i / 12][i % 4] = new Vec3(finalCoods[i], finalCoods[i + 1], finalCoods[i + 2]);
        }
        RAAB.transform(positions);
        double[] minMax = RAAB.getMinMax(positions);
        double minX = minMax[0];
        double minY = minMax[1];
        double minZ = minMax[2];
        double maxX = minMax[3];
        double maxY = minMax[4];
        double maxZ = minMax[5];
        if (!RAAB.validateBox(positions)) {
            throw new InstantiationError("Invalid box, coordinates either don't line up or are null");
        }
        return new RAAB(positions, minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void offsetBottom(float y) {
        for (int i = 0; i < this.positions[0].length; ++i) {
            this.positions[0][i] = this.positions[0][i].m_82520_(0.0, (double)y, 0.0);
        }
    }

    public boolean m_82314_(double x1, double y1, double z1, double x2, double y2, double z2) {
        Vec3[] axes;
        Vec3 start = new Vec3(x1, y1, z1);
        Vec3 end = new Vec3(x2, y2, z2);
        Vec3 direction = end.m_82546_(start);
        for (Vec3 axis : axes = this.getAxes()) {
            if (this.overlapOnAxis(axis, start, direction)) continue;
            return false;
        }
        return true;
    }

    public boolean m_82393_(double x, double y, double z) {
        Vec3 point = this.transformToLocal(new Vec3(x, y, z));
        double u = point.f_82479_;
        double v = point.f_82480_;
        double w = point.f_82481_;
        return u >= 0.0 && u <= 1.0 && v >= 0.0 && v <= 1.0 && w >= 0.0 && w <= 1.0;
    }

    private Vec3 transformToLocal(Vec3 point) {
        Vec3 bottomLeft = this.positions[0][0];
        Vec3 bottomRightLocal = this.positions[0][1].m_82546_(bottomLeft);
        Vec3 topLeftLocal = this.positions[0][3].m_82546_(bottomLeft);
        Vec3 bottomLeftLocal = this.positions[1][0].m_82546_(bottomLeft);
        Vec3 pointLocal = point.m_82546_(bottomLeft);
        double brSqrLength = bottomRightLocal.m_82526_(bottomRightLocal);
        double brTlAlign = bottomRightLocal.m_82526_(topLeftLocal);
        double brBtAlign = bottomRightLocal.m_82526_(bottomLeftLocal);
        double tlSqrLength = topLeftLocal.m_82526_(topLeftLocal);
        double tLBlAlign = topLeftLocal.m_82526_(bottomLeftLocal);
        double bLSqrLength = bottomLeftLocal.m_82526_(bottomLeftLocal);
        double pLBrAlign = pointLocal.m_82526_(bottomRightLocal);
        double pLTlAlign = pointLocal.m_82526_(topLeftLocal);
        double pLBlAlign = pointLocal.m_82526_(bottomLeftLocal);
        double determinant = brSqrLength * (tlSqrLength * bLSqrLength - tLBlAlign * tLBlAlign) - brTlAlign * (brTlAlign * bLSqrLength - tLBlAlign * brBtAlign) + brBtAlign * (brTlAlign * tLBlAlign - tlSqrLength * brBtAlign);
        double invDet = 1.0 / determinant;
        double u = (tlSqrLength * bLSqrLength - tLBlAlign * tLBlAlign) * pLBrAlign + (brBtAlign * tLBlAlign - brTlAlign * bLSqrLength) * pLTlAlign + (brTlAlign * tLBlAlign - brBtAlign * tlSqrLength) * pLBlAlign;
        double v = (tLBlAlign * brBtAlign - bLSqrLength * brTlAlign) * pLBrAlign + (brSqrLength * bLSqrLength - brBtAlign * brBtAlign) * pLTlAlign + (brBtAlign * brTlAlign - brSqrLength * tLBlAlign) * pLBlAlign;
        double w = (brTlAlign * tLBlAlign - tlSqrLength * brBtAlign) * pLBrAlign + (brBtAlign * brTlAlign - brSqrLength * tLBlAlign) * pLTlAlign + (brSqrLength * tlSqrLength - brTlAlign * brTlAlign) * pLBlAlign;
        return new Vec3(u *= invDet, v *= invDet, w *= invDet);
    }

    private Vec3[] getAxes() {
        int i;
        Vec3[] axes = new Vec3[20];
        int index = 0;
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                Vec3 edge = this.positions[i][(j + 1) % 4].m_82546_(this.positions[i][j]);
                axes[index++] = edge.m_82541_();
            }
        }
        for (i = 0; i < 4; ++i) {
            Vec3 edge = this.positions[0][(i + 1) % 4].m_82546_(this.positions[0][i]);
            axes[index++] = edge.m_82537_(new Vec3(1.0, 0.0, 0.0)).m_82541_();
            axes[index++] = edge.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
            axes[index++] = edge.m_82537_(new Vec3(0.0, 0.0, 1.0)).m_82541_();
        }
        return axes;
    }

    private boolean overlapOnAxis(Vec3 axis, Vec3 start, Vec3 direction) {
        double[] lineProjection;
        double[] prismProjection = this.projectPrism(axis);
        return prismProjection[1] >= (lineProjection = this.projectLine(axis, start, direction))[0] && lineProjection[1] >= prismProjection[0];
    }

    private double[] projectPrism(Vec3 axis) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        Vec3[][] vec3Array = this.positions;
        int n = vec3Array.length;
        for (int i = 0; i < n; ++i) {
            Vec3[] layer;
            for (Vec3 vertex : layer = vec3Array[i]) {
                double projection = vertex.m_82526_(axis);
                min = Math.min(min, projection);
                max = Math.max(max, projection);
            }
        }
        return new double[]{min, max};
    }

    private double[] projectLine(Vec3 axis, Vec3 start, Vec3 direction) {
        double startProjection = start.m_82526_(axis);
        double endProjection = start.m_82549_(direction).m_82526_(axis);
        return new double[]{Math.min(startProjection, endProjection), Math.max(startProjection, endProjection)};
    }

    public AABB getBox() {
        return new AABB(this.f_82288_, this.f_82289_, this.f_82290_, this.f_82291_, this.f_82292_, this.f_82293_);
    }

    public void forCorners(BiConsumer<Integer[], Vec3> consumer) {
        for (int i = 0; i < this.positions.length; ++i) {
            for (int j = 0; j < this.positions[i].length; ++j) {
                consumer.accept(new Integer[]{i, j}, this.positions[i][j]);
            }
        }
    }

    private static void transform(Vec3[][] positions) {
        Direction eastRelative = Vec3Helper.getDirection(positions[0][0], positions[0][1]);
        Direction northRelative = Vec3Helper.getDirection(positions[0][0], positions[0][3]);
        positions[0][1] = positions[0][1].m_231075_(eastRelative, 1.0);
        positions[0][2] = positions[0][2].m_231075_(eastRelative, 1.0).m_231075_(northRelative, 1.0);
        positions[0][3] = positions[0][3].m_231075_(northRelative, 1.0);
        positions[1][0] = positions[1][0].m_82520_(0.0, 1.0, 0.0);
        positions[1][1] = positions[1][1].m_231075_(eastRelative, 1.0).m_82520_(0.0, 1.0, 0.0);
        positions[1][2] = positions[1][2].m_231075_(eastRelative, 1.0).m_231075_(northRelative, 1.0).m_82520_(0.0, 1.0, 0.0);
        positions[1][3] = positions[1][3].m_231075_(northRelative, 1.0).m_82520_(0.0, 1.0, 0.0);
    }

    private static double[] getMinMax(Vec3[][] positions) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        double maxZ = Double.MIN_VALUE;
        Vec3[][] vec3Array = positions;
        int n = vec3Array.length;
        for (int i = 0; i < n; ++i) {
            Vec3[] layer;
            for (Vec3 pos : layer = vec3Array[i]) {
                minX = Math.min(minX, pos.f_82479_);
                minY = Math.min(minY, pos.f_82480_);
                minZ = Math.min(minZ, pos.f_82481_);
                maxX = Math.max(maxX, pos.f_82479_);
                maxY = Math.max(maxY, pos.f_82480_);
                maxZ = Math.max(maxZ, pos.f_82481_);
            }
        }
        return new double[]{minX, minY, minZ, maxX, maxY, maxZ};
    }

    private void transform() {
        RAAB.transform(this.positions);
    }

    public float[] getAngle(int layer1, int layer2, int index1, int index2) {
        Vec3 pos1 = this.positions[layer1][index1];
        Vec3 pos2 = this.positions[layer2][index2];
        return Vec3Helper.getDegreesBetweenPoints(pos1, pos2);
    }

    private static boolean validateBox(Vec3[][] positions) {
        Vec3[] bottomPositions = positions[0];
        Vec3[] topPositions = positions[1];
        for (int i = 0; i < topPositions.length; ++i) {
            Vec3 bottom = bottomPositions[i];
            Vec3 top = topPositions[i];
            if (bottom == null || top == null) {
                return false;
            }
            if (top.f_82479_ == bottom.f_82479_ && top.f_82481_ == bottom.f_82481_) continue;
            return false;
        }
        return true;
    }
}

