/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.helper.vec3;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.refractionapi.refraction.helper.math.EasingFunctions;
import net.refractionapi.refraction.helper.runnable.Runnabler;

public class Vec3Helper {
    private static final RandomSource random = RandomSource.m_216327_();

    public static Vec3 getLookAtVec3(LivingEntity livingEntity, double range) {
        Vec3 vec3 = livingEntity.m_146892_();
        Vec3 vec31 = Vec3Helper.calculateViewVector(livingEntity.m_146909_(), livingEntity.m_146908_()).m_82490_(range);
        return vec3.m_82549_(vec31);
    }

    public static Vec3 getLookAtVec3NoXRot(LivingEntity livingEntity, double range) {
        Vec3 vec3 = livingEntity.m_146892_();
        Vec3 vec31 = Vec3Helper.calculateViewVector(0.0f, livingEntity.m_146908_()).m_82490_(range);
        return vec3.m_82549_(vec31);
    }

    public static Vec3 getLookAtVec3NoYRot(LivingEntity livingEntity, double range) {
        Vec3 vec3 = livingEntity.m_146892_();
        Vec3 vec31 = Vec3Helper.calculateViewVector(livingEntity.m_146909_(), 0.0f).m_82490_(range);
        return vec3.m_82549_(vec31);
    }

    public static Vec3 calculateViewVector(float pXRot, float pYRot) {
        float f = pXRot * ((float)Math.PI / 180);
        float f1 = -pYRot * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static void knockback(LivingEntity toKnockback, LivingEntity from, float strength) {
        toKnockback.m_147240_((double)strength, (double)Mth.m_14031_((float)(from.m_5675_(1.0f) * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(from.m_5686_(1.0f) * ((float)Math.PI / 180)))));
    }

    public static float[] getDegreesBetweenPoints(Vec3 pos1, Vec3 pos2) {
        double differenceInX = pos1.f_82479_ - pos2.f_82479_;
        double differenceInY = pos1.f_82480_ - pos2.f_82480_;
        double differenceInZ = pos1.f_82481_ - pos2.f_82481_;
        double length = Math.sqrt(differenceInX * differenceInX + differenceInZ * differenceInZ);
        return new float[]{Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)differenceInY, (double)length) * 57.2957763671875)))), Mth.m_14177_((float)((float)(Mth.m_14136_((double)differenceInZ, (double)differenceInX) * 57.2957763671875) - 90.0f))};
    }

    public static boolean isInAngle(Vec3 from, Vec3 to, float xRot, float yRot, double angle) {
        Vec3 dirVec = new Vec3(to.f_82479_ - from.f_82479_, to.f_82480_ - from.f_82480_, to.f_82481_ - from.f_82481_).m_82541_();
        double dot = dirVec.m_82526_(Vec3Helper.calculateViewVector(xRot, yRot).m_82541_());
        return dot >= Mth.m_14139_((double)(angle / 360.0), (double)1.0, (double)-1.0);
    }

    public static boolean isInAngle(Entity entity, Vec3 vec3, double angle) {
        return Vec3Helper.isInAngle(entity.m_20182_(), vec3, entity.m_146909_(), entity.m_146908_(), angle);
    }

    public static boolean isInAngle(Entity entity, BlockPos pos, double angle) {
        return Vec3Helper.isInAngle(entity, pos.m_252807_(), angle);
    }

    public static boolean isEntityMoving(LivingEntity livingEntity) {
        return livingEntity.f_19787_ - livingEntity.f_19867_ > 0.0f;
    }

    public static float getMovingDifference(LivingEntity livingEntity) {
        return livingEntity.f_19787_ - livingEntity.f_19867_;
    }

    public static boolean isEntityMovingClient(LivingEntity livingEntity) {
        return livingEntity.m_20185_() - livingEntity.f_19790_ != 0.0 || livingEntity.m_20186_() - livingEntity.f_19791_ != 0.0 || livingEntity.m_20189_() - livingEntity.f_19792_ != 0.0;
    }

    public static void smoothLerp(Entity entity, Vec3 start, Vec3 end, int ticks, EasingFunctions easingFunction) {
        Runnabler.create().run(ticks, runnabler -> {
            float lerpTicks = (float)(ticks - runnabler.ticksLeft()) / (float)ticks;
            lerpTicks = easingFunction.getEasing(lerpTicks);
            Vec3 lerp = start.m_165921_(end, (double)lerpTicks);
            Vec3 currentPos = entity.m_20182_();
            Vec3 delta = lerp.m_82546_(currentPos);
            entity.m_20256_(delta);
            entity.f_19864_ = true;
            entity.m_20343_(lerp.f_82479_, lerp.f_82480_, lerp.f_82481_);
        });
    }

    public static Vec3 getVec(LivingEntity livingEntity, float distance) {
        return Vec3Helper.getVec(livingEntity, distance, 0.0f);
    }

    public static Vec3 getVec(LivingEntity livingEntity, float distance, float offset) {
        return Vec3Helper.getVec(livingEntity, livingEntity.m_146909_(), livingEntity.m_146908_(), distance, offset);
    }

    public static Vec3 getVec(LivingEntity livingEntity, float distance, float offset, float yOffset) {
        return Vec3Helper.getVec(livingEntity, livingEntity.m_146909_(), livingEntity.m_146908_(), distance, offset, yOffset);
    }

    public static Vec3 getVecNoXRot(LivingEntity livingEntity, float distance, float offset, float yOffset) {
        return Vec3Helper.getVec(livingEntity, 0.0f, livingEntity.m_146908_(), distance, offset, yOffset);
    }

    public static Vec3 getVec(LivingEntity livingEntity, float xRot, float yRot, float distance, float offset) {
        return Vec3Helper.getVec(livingEntity, xRot, yRot, distance, offset, 0.0f);
    }

    public static Vec3 getVec(LivingEntity livingEntity, float xRot, float yRot, float distance, float offset, float yOffset) {
        return Vec3Helper.getVec(livingEntity.m_146892_(), xRot, yRot, distance, offset, yOffset);
    }

    public static Vec3 getVec(Vec3 vec3, float xRot, float yRot, float distance, float offset, float yOffset) {
        Vec3 vec31F = Vec3Helper.calculateViewVector(xRot, yRot).m_82490_((double)distance);
        Vec3 vec31S = Vec3Helper.calculateViewVector(xRot, yRot + 90.0f).m_82490_((double)offset);
        Vec3 FBVector = vec3.m_82549_(vec31F);
        Vec3 RLVector = vec3.m_82549_(vec31S);
        Vec3 vectorDifference = FBVector.m_82546_(RLVector);
        return vec3.m_82549_(vectorDifference).m_82520_(0.0, (double)yOffset, 0.0);
    }

    public static Vec3[] getInbetween(Vec3 vec1, Vec3 vec2) {
        return Vec3Helper.getInbetween(vec1, vec2, (int)vec1.m_82554_(vec2));
    }

    public static Vec3[] getInbetween(Vec3 vec1, Vec3 vec2, int steps) {
        Vec3[] inbetween = new Vec3[steps];
        for (int i = 0; i < steps; ++i) {
            inbetween[i] = vec1.m_82549_(vec2.m_82546_(vec1).m_82490_((double)((float)i / (float)steps)));
        }
        return inbetween;
    }

    public static Vec3 getRandomSpherePos(Vec3 origin, float radius) {
        double theta = random.m_188500_() * 2.0 * Math.PI;
        double phi = Math.acos(2.0 * random.m_188500_() - 1.0);
        double r = (double)radius * Math.cbrt(random.m_188500_());
        double x = r * (double)Mth.m_14031_((float)((float)phi)) * (double)Mth.m_14089_((float)((float)theta));
        double y = r * (double)Mth.m_14031_((float)((float)phi)) * (double)Mth.m_14031_((float)((float)theta));
        double z = r * (double)Mth.m_14089_((float)((float)phi));
        return new Vec3(origin.f_82479_ + x, origin.f_82480_ + y, origin.f_82481_ + z);
    }

    public static BlockPos findSolid(Level level, BlockPos start, int y) {
        BlockPos.MutableBlockPos pos = start.m_175288_(y).m_122032_();
        while (level.m_8055_((BlockPos)pos).m_60795_() && pos.m_123342_() > level.m_141937_()) {
            pos.m_122184_(0, -1, 0);
        }
        return pos;
    }

    public static BlockPos findSolid(Level level, BlockPos start) {
        return Vec3Helper.findSolid(level, start, level.m_151558_());
    }

    public static BlockPos findSolid(Level level, Vec3 vec3, float y) {
        return Vec3Helper.findSolid(level, BlockPos.m_274446_((Position)vec3), (int)y);
    }

    public static Vec3[] createRectangle(Vec3 diagonal1, Vec3 diagonal2) {
        Vec3[] corners = new Vec3[]{new Vec3(diagonal2.f_82479_, diagonal1.f_82480_, diagonal1.f_82481_), new Vec3(diagonal1.f_82479_, diagonal2.f_82480_, diagonal2.f_82481_)};
        return corners;
    }

    public static BlockPos[] createRectangle(BlockPos diagonal1, BlockPos diagonal2) {
        BlockPos[] corners = new BlockPos[]{new BlockPos(diagonal2.m_123341_(), diagonal1.m_123342_(), diagonal1.m_123343_()), new BlockPos(diagonal1.m_123341_(), diagonal2.m_123342_(), diagonal2.m_123343_())};
        return corners;
    }

    public static BlockPos max(BlockPos a, BlockPos b) {
        return new BlockPos(Math.max(a.m_123341_(), b.m_123341_()), Math.max(a.m_123342_(), b.m_123342_()), Math.max(a.m_123343_(), b.m_123343_()));
    }

    public static BlockPos min(BlockPos a, BlockPos b) {
        return new BlockPos(Math.min(a.m_123341_(), b.m_123341_()), Math.min(a.m_123342_(), b.m_123342_()), Math.min(a.m_123343_(), b.m_123343_()));
    }

    public static Direction getDirection(Vec3 from, Vec3 to) {
        Vec3 vec3 = to.m_82546_(from);
        return Direction.m_122366_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_);
    }

    public static BlockPos findSolid(Level level, Vec3 vec3) {
        return Vec3Helper.findSolid(level, vec3, (float)vec3.f_82480_);
    }

    public static List<BlockPos> createSphere(BlockPos center, int radius) {
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
        int centerInt = radius / 2;
        for (int x1 = centerInt - radius; x1 < centerInt + radius; ++x1) {
            for (int y1 = centerInt - radius; y1 < centerInt + radius; ++y1) {
                for (int z1 = centerInt - radius; z1 < centerInt + radius; ++z1) {
                    int squareDistance = (x1 - centerInt) * (x1 - centerInt) + (y1 - centerInt) * (y1 - centerInt) + (z1 - centerInt) * (z1 - centerInt);
                    if (squareDistance > radius * radius) continue;
                    ret.add(new BlockPos(center.m_123341_() + x1 - centerInt, center.m_123342_() + y1, center.m_123343_() + z1 - centerInt));
                }
            }
        }
        return ret;
    }

    public static List<BlockPos> createHollowSphere(BlockPos center, int radius) {
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
        int centerInt = radius / 2;
        for (int x1 = centerInt - radius; x1 < centerInt + radius; ++x1) {
            for (int y1 = centerInt - radius; y1 < centerInt + radius; ++y1) {
                for (int z1 = centerInt - radius; z1 < centerInt + radius; ++z1) {
                    int squareDistance = (x1 - centerInt) * (x1 - centerInt) + (y1 - centerInt) * (y1 - centerInt) + (z1 - centerInt) * (z1 - centerInt);
                    if (squareDistance > radius * radius || squareDistance < (radius - 1) * (radius - 1)) continue;
                    ret.add(new BlockPos(center.m_123341_() + x1 - centerInt, center.m_123342_() + y1, center.m_123343_() + z1 - centerInt));
                }
            }
        }
        return ret;
    }

    public static List<BlockPos> circle(BlockPos center, int radius) {
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
        int centerInt = radius / 2;
        for (int x1 = centerInt - radius; x1 < centerInt + radius; ++x1) {
            for (int z1 = centerInt - radius; z1 < centerInt + radius; ++z1) {
                int squareDistance = (x1 - centerInt) * (x1 - centerInt) + (z1 - centerInt) * (z1 - centerInt);
                if (squareDistance > radius * radius) continue;
                ret.add(new BlockPos(center.m_123341_() + x1 - centerInt, center.m_123342_(), center.m_123343_() + z1 - centerInt));
            }
        }
        return ret;
    }
}

