/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.helper.vec3;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.refractionapi.refraction.helper.runnable.TickableProccesor;
import net.refractionapi.refraction.helper.vec3.Vec3Helper;

public class Viewer {
    protected final LevelAccessor level;
    protected Vec3 origin = Vec3.f_82478_;
    protected Consumer<Entity> onLook = e -> {};
    protected Consumer<Entity> onStopLooking = e -> {};
    protected Consumer<Entity> whileLooking = e -> {};
    protected Runnable noObservor = () -> {};
    protected Runnable hasObservor = () -> {};
    protected Predicate<Entity> entityPredicate = e -> true;
    protected float fovRange = 90.0f;
    protected float range = 12.0f;
    protected List<Entity> previous = new ArrayList<Entity>();
    private boolean discarded = false;
    private BooleanSupplier shouldRun = () -> !this.discarded;

    public Viewer(LevelAccessor level) {
        this.level = level;
        new TickableProccesor().process((accessor, post) -> this.tick()).shouldRun(this.shouldRun).start(this.level);
    }

    public Viewer setOrigin(Vec3 origin) {
        this.origin = origin;
        return this;
    }

    public Viewer setOrigin(double x, double y, double z) {
        this.origin = new Vec3(x, y, z);
        return this;
    }

    public Viewer onLook(Consumer<Entity> consumer) {
        this.onLook = consumer;
        return this;
    }

    public Viewer onStopLooking(Consumer<Entity> consumer) {
        this.onStopLooking = consumer;
        return this;
    }

    public Viewer whileLooking(Consumer<Entity> consumer) {
        this.whileLooking = consumer;
        return this;
    }

    public Viewer noObservor(Runnable runnable) {
        this.noObservor = runnable;
        return this;
    }

    public Viewer hasObservor(Runnable runnable) {
        this.hasObservor = runnable;
        return this;
    }

    public Viewer predicate(Predicate<Entity> predicate) {
        this.entityPredicate = predicate;
        return this;
    }

    public Viewer setFovRange(float range) {
        this.fovRange = range;
        return this;
    }

    public Viewer setRange(float range) {
        this.range = range;
        return this;
    }

    public Viewer shouldRun(BooleanSupplier shouldRun) {
        this.shouldRun = shouldRun;
        return this;
    }

    public void discard() {
        this.discarded = true;
    }

    protected void tick() {
        List<Entity> lookers = this.getLookers();
        lookers.stream().filter(entity -> this.previous.stream().noneMatch(e -> e.equals(entity))).forEach(newEntity -> this.onLook.accept((Entity)newEntity));
        this.previous.stream().filter(entity -> lookers.stream().noneMatch(e -> e.equals(entity))).forEach(oldEntity -> this.onStopLooking.accept((Entity)oldEntity));
        if (!lookers.isEmpty()) {
            lookers.forEach(this.whileLooking);
            this.hasObservor.run();
        } else {
            this.noObservor.run();
        }
        this.previous = lookers;
    }

    protected List<Entity> getLookers() {
        return this.level.m_6249_((Entity)null, new AABB(this.origin.m_82520_((double)this.range, (double)this.range, (double)this.range), this.origin.m_82492_((double)this.range, (double)this.range, (double)this.range)), entity -> Vec3Helper.isInAngle(entity, this.origin, (double)this.fovRange) && this.entityPredicate.test((Entity)entity));
    }
}

