/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.helper.vfx;

import com.mojang.math.Axis;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.refractionapi.refraction.helper.math.ColorUtils;
import net.refractionapi.refraction.helper.math.EasingFunction;
import net.refractionapi.refraction.helper.math.EasingFunctions;
import net.refractionapi.refraction.helper.registry.RRegister;
import net.refractionapi.refraction.helper.runnable.Runnabler;
import net.refractionapi.refraction.helper.vfx.ParticlerParticle;
import net.refractionapi.refraction.helper.vfx.ParticlerType;
import net.refractionapi.refraction.helper.vfx.VFXWrapper;
import net.refractionapi.refraction.helper.vfx.VFXer;
import net.refractionapi.refraction.util.Pair;

public class Particler
extends VFXWrapper<Particler> {
    private final RRegister<ParticlerType> particleRegister;
    private BiConsumer<Runnabler, ParticlerParticle> onTick = (runnabler, particle) -> {};
    private Vec3 spawn = Vec3.f_82478_;
    private ParticlerParticle particlerParticle;
    private int lifetime = 0;
    private float gravity = 0.0f;

    public Particler(VFXer vfXer, RRegister<ParticlerType> particleRegister) {
        super(vfXer);
        this.particleRegister = particleRegister;
        ParticleEngine engine = Minecraft.m_91087_().f_91061_;
        this.particlerParticle = (ParticlerParticle)engine.m_107370_((ParticleOptions)this.particleRegister.get(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public Particler onTick(BiConsumer<Runnabler, ParticlerParticle> onTick) {
        this.onTick = onTick;
        return this;
    }

    public Particler setSpawn(Vec3 spawn) {
        this.spawn = spawn;
        return this;
    }

    public Particler setLifetime(int lifetime) {
        this.lifetime = lifetime;
        return this;
    }

    public Particler setGravity(float gravity) {
        this.gravity = gravity;
        return this;
    }

    public Particler spawn(Vec3 spawn) {
        this.setSpawn(spawn);
        return this.spawn();
    }

    public Particler spawn(float x, float y, float z) {
        return this.spawn(new Vec3((double)x, (double)y, (double)z));
    }

    public Particler transparency(FloatSetting transparency) {
        this.particlerParticle.transparency = transparency;
        return this;
    }

    public Particler scale(FloatSetting scale) {
        this.particlerParticle.scale = scale;
        return this;
    }

    public Particler rotation(RotationSetting rotation) {
        RotationSetting[] rotationsClone = new RotationSetting[this.particlerParticle.rotations.length + 1];
        System.arraycopy(this.particlerParticle.rotations, 0, rotationsClone, 0, this.particlerParticle.rotations.length);
        rotationsClone[this.particlerParticle.rotations.length] = rotation;
        this.particlerParticle.rotations = rotationsClone;
        return this;
    }

    public Particler color(ColorSetting color) {
        this.particlerParticle.color = color;
        return this;
    }

    public ParticlerParticle particle() {
        return this.particlerParticle;
    }

    @Override
    public Particler spawn() {
        ParticleEngine engine = Minecraft.m_91087_().f_91061_;
        if (this.particlerParticle == null) {
            throw new NullPointerException("Failed to create particle %s".formatted(this.particleRegister.getId()));
        }
        this.particlerParticle.onTick(this.onTick);
        this.particlerParticle.m_107257_(this.lifetime);
        this.particlerParticle.setGravity(this.gravity);
        engine.m_107344_((Particle)this.particlerParticle);
        this.particlerParticle.setRunnabler(Runnabler.createClient().delayRun(this.lifetime, runnabler -> this.remove()));
        VFXer.activeWrappers.add(this);
        return this;
    }

    @Override
    public void remove() {
        if (this.particlerParticle != null) {
            this.particlerParticle.m_107274_();
        }
        VFXer.activeWrappers.remove(this);
    }

    public static class FloatSetting
    extends Setting<Float> {
        public FloatSetting of(float value) {
            this.progression = Pair.of(Float.valueOf(value), Float.valueOf(value));
            return this;
        }

        public FloatSetting of(float start, float end) {
            this.progression = Pair.of(Float.valueOf(start), Float.valueOf(end));
            return this;
        }

        public FloatSetting of(float start, float end, EasingFunction easing) {
            this.progression = Pair.of(Float.valueOf(start), Float.valueOf(end));
            this.easing = easing;
            return this;
        }

        @Override
        public Float get(float delta) {
            return Float.valueOf(Mth.m_14179_((float)this.easing.getEasing(delta), (float)((Float)this.progression.getFirst()).floatValue(), (float)((Float)this.progression.getSecond()).floatValue()));
        }
    }

    public static class RotationSetting
    extends FloatSetting {
        private final Axis axis;

        public RotationSetting(Axis axis) {
            this.axis = axis;
        }

        @Override
        public RotationSetting of(float value) {
            this.progression = Pair.of(Float.valueOf(value), Float.valueOf(value));
            return this;
        }

        @Override
        public RotationSetting of(float start, float end) {
            this.progression = Pair.of(Float.valueOf(start), Float.valueOf(end));
            return this;
        }

        @Override
        public RotationSetting of(float start, float end, EasingFunction easing) {
            this.progression = Pair.of(Float.valueOf(start), Float.valueOf(end));
            this.easing = easing;
            return this;
        }

        public Axis getAxis() {
            return this.axis;
        }
    }

    public static class ColorSetting
    extends IntegerSetting {
        @Override
        public ColorSetting of(int start, int end) {
            this.progression = Pair.of(start, end);
            return this;
        }

        public ColorSetting of(int color) {
            this.progression = Pair.of(color, color);
            return this;
        }

        @Override
        public ColorSetting of(int start, int end, EasingFunction easing) {
            this.progression = Pair.of(start, end);
            this.easing = easing;
            return this;
        }

        public ColorSetting of(float r1, float g1, float b1, float r2, float g2, float b2, EasingFunction function) {
            this.progression = Pair.of(Mth.m_14159_((float)r1, (float)g1, (float)b1), Mth.m_14159_((float)r2, (float)g2, (float)b2));
            this.easing = function;
            return this;
        }

        public ColorSetting of(float r1, float g1, float b1, float r2, float g2, float b2) {
            this.progression = Pair.of(Mth.m_14159_((float)r1, (float)g1, (float)b1), Mth.m_14159_((float)r2, (float)g2, (float)b2));
            return this;
        }

        @Override
        public Integer get(float delta) {
            return ColorUtils.interpolateColor((Integer)this.progression.getFirst(), (Integer)this.progression.getSecond(), this.easing.getEasing(delta));
        }
    }

    private static abstract class Setting<T> {
        protected Pair<T, T> progression;
        protected EasingFunction easing = EasingFunctions.LINEAR;

        private Setting() {
        }

        public abstract T get(float var1);
    }

    public static class IntegerSetting
    extends Setting<Integer> {
        public IntegerSetting of(int start, int end) {
            this.progression = Pair.of(start, end);
            return this;
        }

        public IntegerSetting of(int start, int end, EasingFunction easing) {
            this.progression = Pair.of(start, end);
            this.easing = easing;
            return this;
        }

        @Override
        public Integer get(float delta) {
            return Mth.m_14143_((float)Mth.m_14179_((float)this.easing.getEasing(delta), (float)((Integer)this.progression.getFirst()).intValue(), (float)((Integer)this.progression.getSecond()).intValue()));
        }
    }
}

